import json

# Not included:
# W. Sahara, Fr. S. Antarctic Lands, Palestine, Somaliland, N. Cyprus, Antartica

cia_report = [
    {"Fiji": {"languages": {"English": 100, "Fijian": 100, "Hindi": 100}}},
    {"Tanzania": {"languages": {"Kiswahili": 100, "English": 100}}},
    {"Canada": {"languages": {"English": 58.7, "French": 22, "Punjabi": 1.4}}},
    {"United States of America": {"languages": {"English": 78.2, "Spanish": 13.4, "Chinese": 1.1}}},
    {"Kazakhstan": {"languages": {"Kazakh": 83.1, "Russian": 94.4}}},
    {"Uzbekistan": {"languages": {"Uzbek": 74.3, "Russian": 14.2, "Tajik": 4.4}}},
    {"Papua New Guinea": {"languages": {"Tok Pisin": 48.9, "Hiri Motu": 4.7, "English": 1.7}}},
    {"Indonesia": {"languages": {"Bahasa Indonesia": 100}}},
    {"Argentina": {"languages": {"Spanish": 100}}},
    {"Chile": {"languages": {"Spanish": 99.5, "English": 10.2}}},
    {"Congo, Democratic Republic of the": {"languages": {"French": 100}}},
    {"Somalia": {"languages": {"Somali": 100, "Arabic": 100}}},
    {"Kenya": {"languages": {"English": 100, "Kiswahili": 100}}},
    {"Sudan": {"languages": {"Arabic": 100, "English": 100}}},
    {"Chad": {"languages": {"French": 100, "Arabic": 100}}},
    {"Haiti": {"languages": {"French": 100, "Creole": 100}}},
    {"Dominican Republic": {"languages": {"Spanish": 100}}},
    {"Russia": {"languages": {"Russian": 100}}},
    {"Bahamas, The": {"languages": {"English": 100}}},
    {"Norway": {"languages": {"Norwegian": 100}}},
    {"Greenland": {"languages": {"Greenlandic": 100}}},
    {"Timor-Leste": {"languages": {"Tetun Prasa": 30.6, "Mambai": 16.6, "Makasai": 10.5}}},
    {"South Africa": {"languages": {"Zulu": 22.7, "Xhosa": 16, "Afrikaans": 13.5}}},
    {"Lesotho": {"languages": {"Sesotho": 100, "English": 100}}},
    {"Mexico": {"languages": {"Spanish": 100}}},
    {"Uruguay": {"languages": {"Spanish": 100}}},
    {"Brazil": {"languages": {"Portuguese": 100}}},
    {"Bolivia": {"languages": {"Spanish": 60.7, "Quechua": 21.2, "Aymara": 14.6}}},
    {"Peru": {"languages": {"Spanish": 82.9, "Quechua": 13.6, "Aymara": 1}}},
    {"Colombia": {"languages": {"Spanish": 100}}},
    {"Panama": {"languages": {"Spanish": 100}}},
    {"Costa Rica": {"languages": {"Spanish": 100}}},
    {"Nicaragua": {"languages": {"Spanish": 95.3, "Miskito": 2.2}}},
    {"Honduras": {"languages": {"Spanish": 100}}},
    {"El Salvador": {"languages": {"Spanish": 100}}},
    {"Guatemala": {"languages": {"Spanish": 69.9, "Amerindian": 30}}},
    {"Belize": {"languages": {"English": 62.9, "Spanish": 56.6, "Creole": 44.6}}},
    {"Venezuela": {"languages": {"Spanish": 100}}},
    {"Guyana": {"languages": {"English": 100}}},
    {"Suriname": {"languages": {"Dutch": 100}}},
    {"France": {"languages": {"French": 100}}},
    {"Ecuador": {"languages": {"Spanish": 93, "Quechua": 4.1}}},
    {"Puerto Rico": {"languages": {"Spanish": 94.3, "English": 5.5}}},
    {"Jamaica": {"languages": {"English": 100}}},
    {"Cuba": {"languages": {"Spanish": 100}}},
    {"Zimbabwe": {"languages": {"Shona": 70, "Ndebele": 20, "English": 100}}},
    {"Botswana": {"languages": {"Setswana": 77.3, "Sekalanga": 7.4, "Shekgalagadi": 3.4}}},
    {"Namibia": {"languages": {"Oshiwambo": 49.7, "Nama/Damara": 11, "Kavango": 10.4}}},
    {"Senegal": {"languages": {"French": 100}}},
    {"Mali": {"languages": {"French": 100}}},
    {"Mauritania": {"languages": {"Arabic": 100}}},
    {"Benin": {"languages": {"French": 100}}},
    {"Niger": {"languages": {"French": 100}}},
    {"Nigeria": {"languages": {"English": 100}}},
    {"Cameroon": {"languages": {"English": 100, "French": 100}}},
    {"Togo": {"languages": {"French": 100}}},
    {"Ghana": {"languages": {"Asante": 16, "Ewe": 14, "Fante": 11.6}}},
    {"Cote d'Ivoire": {"languages": {"French": 100}}},
    {"Guinea": {"languages": {"French": 100}}},
    {"Guinea-Bissau": {"languages": {"Portuguese": 100}}},
    {"Liberia": {"languages": {"English": 20}}},
    {"Sierra Leone": {"languages": {"English": 100}}},
    {"Burkina Faso": {"languages": {"French": 100}}},
    {"Central African Republic": {"languages": {"French": 100, "Sangho": 100}}},
    {"Congo, Republic of the": {"languages": {"French": 100}}},
    {"Gabon": {"languages": {"French": 100}}},
    {"Equatorial Guinea": {"languages": {"Spanish": 67.6}}},
    {"Zambia": {"languages": {"Bemba": 33.4, "Nyanja": 14.7, "Tonga": 11.4}}},
    {"Malawi": {"languages": {"English": 100}}},
    {"Mozambique": {"languages": {"Emakhuwa": 25.3, "Portuguese": 10.7, "Xichangana": 10.3}}},
    {"Eswatini": {"languages": {"English": 100, "siSwati": 100}}},
    {"Angola": {"languages": {"Portuguese": 71.2, "Umbundu": 23, "Kikongo": 8.2}}},
    {"Burundi": {"languages": {"Kirundi": 100, "French": 100}}},
    {"Israel": {"languages": {"Hebrew": 100, "Arabic": 100}}},
    {"Lebanon": {"languages": {"Arabic": 100}}},
    {"Madagascar": {"languages": {"Malagasy": 100, "French": 100}}},
    {"Gambia, The": {"languages": {"English": 100}}},
    {"Tunisia": {"languages": {"Arabic": 100}}},
    {"Algeria": {"languages": {"Arabic": 100, "French": 33, "Berber": 50}}},
    {"Jordan": {"languages": {"Arabic": 100}}},
    {"United Arab Emirates": {"languages": {"Arabic": 100}}},
    {"Qatar": {"languages": {"Arabic": 100}}},
    {"Kuwait": {"languages": {"Arabic": 100}}},
    {"Iraq": {"languages": {"Arabic": 100, "Kurdish": 100}}},
    {"Oman": {"languages": {"Arabic": 100}}},
    {"Vanuatu": {"languages": {"Bislama": 100, "English": 100, "French": 100}}},
    {"Cambodia": {"languages": {"Khmer": 96.3}}},
    {"Thailand": {"languages": {"Thai": 90.7, "Burmese": 1.3}}},
    {"Laos": {"languages": {"Lao": 100}}},
    {"Myanmar": {"languages": {"Burmese": 100}}},
    {"Vietnam": {"languages": {"Vietnamese": 100}}},
    {"Korea, North": {"languages": {"Korean": 100}}},
    {"Korea, South": {"languages": {"Korean": 100}}},
    {"Mongolia": {"languages": {"Mongolian": 90, "Turkic": 6, "Russian": 2}}},
    {"India": {"languages": {"Hindi": 43.6, "Bengali": 8, "Marathi": 6.9}}},
    {"Bangladesh": {"languages": {"Bangla": 98.8}}},
    {"Bhutan": {"languages": {"Sharchhopka": 28, "Dzongkha": 24, "Lhotshamkha": 22}}},
    {"Nepal": {"languages": {"Nepali": 44.6, "Maithali": 11.7, "Bhojpuri": 6}}},
    {"Pakistan": {"languages": {"Punjabi": 48, "Pashto": 18, "Sindhi": 12}}},
    {"Afghanistan": {"languages": {"Afghan Persian": 77, "Pashto": 48, "Uzbek": 11}}},
    {"Tajikistan": {"languages": {"Tajik": 84.4, "Uzbek": 11.9, "Russian": 5}}},
    {"Kyrgyzstan": {"languages": {"Kyrgyz": 71.4, "Uzbek": 14.4, "Russian": 9}}},
    {"Turkmenistan": {"languages": {"Turkmen": 72, "Russian": 12}}},
    {"Iran": {"languages": {"Persian": 100}}},
    {"Syria": {"languages": {"Arabic": 100}}},
    {"Armenia": {"languages": {"Armenian": 97.9, "Kurdish": 1}}},
    {"Sweden": {"languages": {"Swedish": 100}}},
    {"Belarus": {"languages": {"Russian": 70.2, "Belarusian": 23.4}}},
    {"Ukraine": {"languages": {"Ukrainian": 67.5, "Russian": 29.6}}},
    {"Poland": {"languages": {"Polish": 98.2, "Silesian": 1.4}}},
    {"Austria": {"languages": {"German": 88.6, "Turkish": 2.3, "Serbian": 2.2}}},
    {"Hungary": {"languages": {"Hungarian": 98.8, "English": 25.3, "German": 12.6}}},
    {"Moldova": {"languages": {"Romanian": 80.2, "Russian": 9.7, "Gagauz": 4.2}}},
    {"Romania": {"languages": {"Romanian": 85.4, "Hungarian": 6.3, "Romani": 1.2}}},
    {"Lithuania": {"languages": {"Lithuanian": 85.3, "Russian": 7.2, "Polish": 5.3}}},
    {"Latvia": {"languages": {"Latvian": 56.3, "Russian": 33.8}}},
    {"Estonia": {"languages": {"Estonian": 68.5, "Russian": 29.6}}},
    {"Germany": {"languages": {"German": 100}}},
    {"Bulgaria": {"languages": {"Bulgarian": 76.8, "Turkish": 8.2, "Romani": 3.8}}},
    {"Greece": {"languages": {"Greek": 99}}},
    {"Turkey": {"languages": {"Turkish": 100}}},
    {"Albania": {"languages": {"Albanian": 98.8, "Greek": 0.5}}},
    {"Croatia": {"languages": {"Croatian": 95.6, "Serbian": 1.2}}},
    {"Switzerland": {"languages": {"German": 62, "French": 23, "Italian": 8}}},
    {"Luxembourg": {"languages": {"Luxembourgish": 55.8, "Portuguese": 15.7, "French": 12.1}}},
    {"Belgium": {"languages": {"Dutch": 60, "French": 40, "German": 1}}},
    {"Netherlands": {"languages": {"Dutch": 100}}},
    {"Portugal": {"languages": {"Portuguese": 100}}},
    {"Spain": {"languages": {"Castilian Spanish": 74, "Catalan": 17, "Galician": 7}}},
    {"Ireland": {"languages": {"English": 98.8, "Irish": 1.2}}},
    {"New Caledonia": {"languages": {"French": 100}}},
    {"Solomon Islands": {"languages": {"Melanesian pidgin": 100, "English": 1.6}}},
    {"New Zealand": {"languages": {"English": 95.4, "Maori": 4, "Samoan": 2.2}}},
    {"Australia": {"languages": {"English": 72, "Mandarin": 2.5, "Italian": 1.6}}},
    {"Sri Lanka": {"languages": {"Sinhala": 87, "Tamil": 28.5, "English": 23.8}}},
    {"China": {"languages": {"Mandarin": 100}}},
    {"Taiwan": {"languages": {"Mandarin": 100, "Taiwanese": 70, "Hakka": 30}}},
    {"Italy": {"languages": {"Italian": 100}}},
    {"Denmark": {"languages": {"Danish": 100}}},
    {"United Kingdom": {"languages": {"English": 100}}},
    {"Iceland": {"languages": {"Icelandic": 98.8, "Polish": 2.8}}},
    {"Azerbaijan": {"languages": {"Azerbaijani": 92.5, "Russian": 1.4, "Armenian": 1.4}}},
    {"Georgia": {"languages": {"Georgian": 87.6, "Azeri": 6.2, "Armenian": 3.9}}},
    {"Philippines": {"languages": {"Filipino": 100, "English": 100}}},
    {"Malaysia": {"languages": {"Bahasa Malaysia": 100}}},
    {"Brunei": {"languages": {"Malay": 100}}},
    {"Slovenia": {"languages": {"Slovene": 91.1, "Serbo-Croatian": 4.5, "Hungarian": 0.4}}},
    {"Finland": {"languages": {"Finnish": 87.6, "Swedish": 5.2, "Russian": 1.4}}},
    {"Slovakia": {"languages": {"Slovak": 81.8, "Hungarian": 8.5, "Roma": 2}}},
    {"Czechia": {"languages": {"Czech": 95.4, "Slovak": 2}}},
    {"Eritrea": {"languages": {"Tigrinya": 100, "Arabic": 100, "English": 100}}},
    {"Japan": {"languages": {"Japanese": 100}}},
    {"Paraguay": {"languages": {"Spanish": 87, "Guarani": 4.6}}},
    {"Yemen": {"languages": {"Arabic": 100}}},
    {"Saudi Arabia": {"languages": {"Arabic": 100}}},
    {"Cyprus": {"languages": {"Greek": 80.9, "Turkish": 0.2, "English": 4.1}}},
    {"Morocco": {"languages": {"Arabic": 100}}},
    {"Egypt": {"languages": {"Arabic": 100}}},
    {"Libya": {"languages": {"Arabic": 100}}},
    {"Ethiopia": {"languages": {"Oromo": 33.8, "Amharic": 29.3, "Somali": 6.2}}},
    {"Djibouti": {"languages": {"French": 100, "Arabic": 100}}},
    {"Uganda": {"languages": {"English": 100, "Swahili": 100}}},
    {"Rwanda": {"languages": {"Kinyarwanda": 100, "French": 100, "English": 100}}},
    {"Bosnia and Herzegovina": {"languages": {"Bosnian": 52.9, "Serbian": 30.8, "Croatian": 14.6}}},
    {"North Macedonia": {"languages": {"Macedonian": 66.5, "Albanian": 25.1, "Turkish": 3.5}}},
    {"Serbia": {"languages": {"Serbian": 88.1, "Hungarian": 3.4, "Bosnian": 1.9}}},
    {"Montenegro": {"languages": {"Serbian": 42.9, "Montenegrin": 37, "Bosnian": 5.3}}},
    {"Kosovo": {"languages": {"Albanian": 94.5, "Bosnian": 1.7, "Serbian": 1.6}}},
    {"Trinidad and Tobago": {"languages": {"English": 100}}},
    {"South Sudan": {"languages": {"English": 100}}}
]

# Sorting the list by the key in each dictionary
sorted_countries = sorted(cia_report, key=lambda x: list(x.keys())[0])

sorted_countries = {k: v for d in sorted_countries for k, v in d.items()}

# Converting the sorted list to JSON format to print it in a readable way
print(json.dumps(sorted_countries, indent=4))

# # save json 
# with open('language_map_cia.json', 'w') as f:
#     json.dump(sorted_countries, f, indent=4)