# List of language codes already included
included_codes = ["ha", "ta", "AR", "BG", "CS", "DA", "DE", "EL", "EN-GB", "EN-US", "ES", "ET", "FI", "FR", "HU", "ID", "IT", "JA", "KO", "LT", "LV", "NB", "NL", "PL", "PT-BR", "PT-PT", "RO", "RU", "SK", "SL", "SV", "TR", "UK", "ZH"]

# Full list of language codes from which to filter out
full_list = ['ts', 'rm', 'my', 'vi', 'en', 'mn', 'zu', 'az', 'tr', 'km', None, 'sn', 'xh', 'lo', 'qu', 'si', 'ta', 'ss', 'es', 'ko', 'tg', 'ti', 'de', 'pt', 'fa', 'bs', 'tk', 'mk', 'fr', 'sg', 'ro', 'am', 'so', 'ay', 'nl', 'ga', 'uz', 'is', 'th', 'fj', 'be', 'ln', 'ur', 'hi', 'it', 'lb', 'af', None, 'dz', 'sr', None, None, 'rw', 'kk', 'hr', 'ka', 'bi', 'mg', 'he', 'gn', 'hy', 'kl', 'mi', 'ho', 'ar', 'tn', None, 'bn', 'sq', 've']

# Standardizing included codes to lower-case for case-insensitive comparison
included_codes = set(code.lower() for code in included_codes if code is not None)

# Filtering out the included codes
filtered_list = [code for code in full_list if (code is not None and code.lower() not in included_codes)]

print("Filtered language codes:")
print(filtered_list)