import sys
from data_generation.constants import *


def custom_variations(relation, variation, default_config, relation_config_copy, cosine_simple=True, cosine_multi=False):
    if cosine_simple or cosine_multi:
        if relation == IN:
            if variation['variation'] == "size":
                relation_config_copy['var_size'] = 0.8
                relation_config_copy['ref_size'] = 0.81

        if relation == MIDDLE:
            if variation['variation'] == "size":
                relation_config_copy['start_point'] = (0, -2.6, 1.0)
                relation_config_copy['end_point'] = (0, 2.6, 1.0)

        if relation in ROTATION_LIST:
            if variation['variation'] == "size":
                relation_config_copy['ref_position'] = (0, 0, variation['ref_size'])
                relation_config_copy['var_position'] = (0, 0, variation['var_size'])
        
        if relation == ABOVE:
            if variation['variation'] == "size":
                relation_config_copy['ref_position'] = (0, 0, variation['ref_size'])

        if relation == UNDER:
            if variation['variation'] == "size":
                relation_config_copy['start_point'] = (0, -2.5, variation['var_size'])
                relation_config_copy['end_point'] = (0, 2.5, variation['var_size'])
        
        if relation == IN_BETWEEN:
            if variation['variation'] == "size":
                relation_config_copy['start_point'] = (-3.85, 0, variation['var_size'])
                relation_config_copy['end_point'] = (3.85, 0, variation['var_size'])
                relation_config_copy['ref_position'] = [(0, -2.5, variation['ref_size']), (0, 2.5, variation['ref_size'])]
    else:
        if relation == ABOVE:
            if variation["variation"] == "size":
                relation_config_copy['ref_position'] = (0, 0, 0.3)
                # relation_config_copy['end_point'] = (0, 2.5, 2.6)
                relation_config_copy['var_size'] = 6
                relation_config_copy['ref_size'] = 2
            
            if variation["variation"] == "color":
                relation_config_copy['var_color'] = CHARCOAL_GRAY
                relation_config_copy['ref_color'] = CAR_BLUE

            # shape
            if variation["variation"] == "shape":
                relation_config_copy['var_shape'] = AEROPLANE_FIGHTER
                relation_config_copy['ref_shape'] = BICYCLE_MOUNTAIN
                relation_config_copy['ref_rotation'] = (90, 0, 90 + default_config['ref_rotation'][2])
                relation_config_copy['ref_position'] = (0, 0, 0.7)
                
        if relation == UNDER:
            if variation["variation"] == "default":
                if relation_config_copy['var_shape'] == CAR_MINIVAN:
                    relation_config_copy['start_point'] = (0, -2.5, 0.5)
                    relation_config_copy['end_point'] = (0, 2.5, 0.5)
                if relation_config_copy['var_shape'] == CAR_TRUCK:
                    relation_config_copy['start_point'] = (0, -2.5, 0.33)
                    relation_config_copy['end_point'] = (0, 2.5, 0.33)

            if variation['variation'] == "size":
                # if relation_config_copy['var_shape'] == CAR_WAGON:
                #     relation_config_copy['start_point'] = (0, -2.5, 0.29)
                #     relation_config_copy['end_point'] = (0, 2.5, 0.29)
                # else:
                relation_config_copy['start_point'] = (0, -2.5, 0.3)
                relation_config_copy['end_point'] = (0, 2.5, 0.3)
                relation_config_copy['var_size'] = 2
                relation_config_copy['ref_size'] = 6

            if variation['variation'] == "color":
                relation_config_copy['var_color'] = CAR_BLUE
                relation_config_copy['ref_color'] = CHARCOAL_GRAY

            if variation["variation"] == "shape":
                relation_config_copy['var_shape'] = BICYCLE_MOUNTAIN
                relation_config_copy['ref_shape'] = AEROPLANE_FIGHTER
                relation_config_copy['start_point'] = (0, -2.5, 0.7)
                relation_config_copy['end_point'] = (0, 2.5, 0.7)
                relation_config_copy['var_rotation'] = (90, 0, 90 + default_config['var_rotation'][2])

        if relation == IN_BETWEEN:
            # if relation_config_copy['var_shape'] == AEROPLANE_BIPLANE:
            #     relation_config_copy['var_rotation'] = (90, 10, -90)
            relation_config_copy['ref_rotation'] = [default_config['ref_rotation'], default_config['ref_rotation']]
            if variation['variation'] == "default":
                if relation_config_copy['ref_shape'] == CAR_MINIVAN:
                    relation_config_copy['ref_position'] = [(0, -3.5, 0.5), (0, 3.5, 0.5)]
            if variation['variation'] == "size":
                relation_config_copy['var_size'] = 3.5
                relation_config_copy['ref_size'] = 2.5
                relation_config_copy['ref_position'] = [(0, -3.5, 0.4), (0, 3.5, 0.4)]

            if variation['variation'] == "color":
                relation_config_copy['var_color'] = CAR_BLUE
                relation_config_copy['ref_color'] = CHARCOAL_GRAY
                relation_config_copy['ref_position'] = [(0, -3.5, 0.55), (0, 3.5, 0.55)]
            
            if variation['variation'] == "shape":
                relation_config_copy['var_shape'] = BICYCLE_MOUNTAIN
                relation_config_copy['ref_shape'] = CAR_TRUCK
                if relation_config_copy['var_shape'] in BICYCLES:
                    relation_config_copy['start_point'] = (-3.85, 0, 0.7)
                    relation_config_copy['end_point'] = (3.85, 0, 0.7)
                relation_config_copy['var_rotation'] = (90, 0, 90+default_config['var_rotation'][2])
                relation_config_copy['ref_position'] = [(0, -3.5, 0.45), (0, 3.5, 0.45)]
                relation_config_copy['ref_rotation'] = [default_config['ref_rotation'], default_config['ref_rotation']]

            if variation['variation'] == "distractor":
                relation_config_copy['ref_position'] = [(0, -3.5, 0.5), (0, 3.5, 0.5)]

        # if relation in ROTATION_LIST:
            # relation_config_copy['var_size'] = 3
            # relation_config_copy['ref_size'] = 0.3

            # if relation_config_copy['ref_shape'] == CAR_MINIVAN:
            #     relation_config_copy['ref_position'] = (0, 0, 0.5)
            #     relation_config_copy['var_position'] = (0, 0, 0.5)

            # if variation['variation'] == "size":
            #     relation_config_copy['var_size'] = 3.5
            #     relation_config_copy['var_position'] = (0, 0, 0.5)
            #     relation_config_copy['ref_size'] = 2.5
            #     relation_config_copy['ref_position'] = (0, 0, 0.4)
            
            # if variation['variation'] == "color":
            #     if relation_config_copy['var_shape'] == CAR_MINIVAN:
            #         relation_config_copy['var_position'][2] = 0.5
            #     relation_config_copy['var_color'] = CAR_BLUE
            #     relation_config_copy['ref_color'] = CHARCOAL_GRAY

            # # shape
            # if variation['variation'] == "shape":
            #     relation_config_copy['ref_shape'] = CAR_TRUCK
            #     relation_config_copy['var_shape'] = BICYCLE_MOUNTAIN

            #     # relation_config_copy['var_color'] = BIKE_YELLOW
            #     if relation_config_copy['var_shape'] in BICYCLES:
            #         relation_config_copy['var_rotation'] = (90, 0, 90 + default_config['var_rotation'][2])
            #     relation_config_copy['var_size'] = 2
                
            #     relation_config_copy['var_position'] = (0, 0, 0.6)
            #     # if relation_config_copy['ref_shape'] == CAR_WAGON:
            #     #     relation_config_copy['ref_position'] = (0, 0, 0.3)
            #     # if relation_config_copy['var_shape'] == BICYCLE_UTILITY:
            #         # relation_config_copy['var_position'] = (0, 0, 0.8)
            #     if relation_config_copy['var_shape'] == CAR_SEDAN:
            #         relation_config_copy['var_position'] = (0, 0, 0.2)
            #     if relation_config_copy['var_shape'] == BICYCLE_MOUNTAIN:
            #         relation_config_copy['var_position'] = (0, 0, 0.5)
            #     if relation_config_copy['var_shape'] == BICYCLE_ROAD:
            #         relation_config_copy['var_position'] = (0, 0, 0.5)

            # if "face" in variation['variation']:
            #     if variation['variation'] == "face_left":
            #         relation_config_copy['ref_rotation'] = (90, 0, 270)
            #     if variation['variation'] == "face_front":
            #         relation_config_copy['ref_rotation'] = (90, 0, -90)
            #     if variation['variation'] == "face_behind":
            #         relation_config_copy['ref_rotation'] = (90, 0, 90)
    return relation_config_copy
