
import os
import sys
sys.path.append(os.getcwd())

import time
import copy
import json
import argparse

import math
import random
import numpy as np
# import PIL.Image as Image
# import matplotlib.pyplot as plt
# import matplotlib.image as mpimg

import cv2
import pprint as pp
import bpy, bpy_extras

from data_generation.simple_configs import *
from data_generation.hard_configs import *
from data_generation.multi_configs import *
from data_generation.constants import *
from data_generation.custom_variations import custom_variations
from data_generation.utils import render_scene_config

def main(args):
    COSINE_SIMPLE = args.cosine_simple
    COSINE_HARD = args.cosine_hard
    COSINE_MULTI = False
    OUTPUT_PATH = args.output_path

    if COSINE_SIMPLE:
        DEFAULT_CONFIG = SIMPLE_DEFAULT_CONFIG
        VARIATIONS = SIMPLE_VARIATIONS
        RELATIONS = SIMPLE_RELATIONS
    if COSINE_HARD:
        DEFAULT_CONFIG = HARD_DEFAULT_CONFIG
        VARIATIONS = HARD_VARIATIONS
        RELATIONS = HARD_RELATIONS
    if COSINE_MULTI:
        DEFAULT_CONFIG = MULTI_DEFAULT_CONFIG
        VARIATIONS = MULTI_VARIATIONS
        RELATIONS = MULTI_RELATIONS

    
    
    # relations_to_test = ALL_RELATIONS
    # DEFAULT_CONFIG['num_distractors'] = 5
    # DEFAULT_CONFIG["num_steps"] = 5
    # relations_to_test = [BEHIND]
    relations_to_test = ROTATION_LIST
    # relations_to_test = [FRONT, LEFT, RIGHT]
    # VARIATIONS = [{"variation": "default"}]
    debug = False

    # Default config is overwritten by the variation.
    # Then the variation is overwritten by relation config.
    # Custom variations can be added here.
    RENDER_SHADOW = True
    if COSINE_SIMPLE:
        repeat = 1
    else:
        if COSINE_MULTI:
            repeat = 1
            RENDER_SHADOW = False
        else:
            repeat = 1

    for i in range(repeat):
        if COSINE_SIMPLE:
            OUTPUT_DIR = f"{OUTPUT_PATH}/cosine_simple_0619"
            DEFAULT_CONFIG['save_path'] = OUTPUT_DIR
        else:
            if COSINE_MULTI:
                if i == 0:
                    OUTPUT_DIR = f"{OUTPUT_PATH}/cosine_multi_init/front_view"
                else:
                    OUTPUT_DIR = f"{OUTPUT_PATH}/multi/side_view"
                DEFAULT_CONFIG['save_path'] = OUTPUT_DIR
            else:
                # DEFAULT_CONFIG['ref_rotation'] = (90, 0, 60*i)
                # DEFAULT_CONFIG['var_rotation'] = (90, 0, 60*i)
                # OUTPUT_DIR = f"/home/name/spatial/LLaVA_interp/data_generation/output/sample_model/orientation_{60*i}"
                OUTPUT_DIR = f"{OUTPUT_PATH}/cosine_hard_0619"
                DEFAULT_CONFIG['save_path'] = OUTPUT_DIR

        for relation, relation_config in RELATIONS.items():
            distractors = []
            for variation in VARIATIONS:
                # variation["num_steps"] = 3
                if relation not in relations_to_test:
                    continue

                if "face" in variation['variation'] and relation not in ROTATION_LIST:
                    continue

                # modification for custom config is done to a copy of config
                relation_config_copy = copy.deepcopy(relation_config)
                relation_config_copy = custom_variations(relation, variation, DEFAULT_CONFIG, relation_config_copy, cosine_simple=COSINE_SIMPLE, cosine_multi=COSINE_MULTI)
                config = {**DEFAULT_CONFIG, **variation, **relation_config_copy}
                # print(config, file=sys.stderr)
                # print(variation, file=sys.stderr)

                # debug
                if debug:
                    pp.pprint(relation, stream=sys.stderr)
                    pp.pprint(variation, stream=sys.stderr)
                    pp.pprint(config, stream=sys.stderr, sort_dicts=False)
                
                # render the scene based on config
                print(f"Variation: {variation['variation']} | Relation: {relation}", file=sys.stderr)
                mapping, distractors = render_scene_config(
                    **config, 
                    distractors=distractors, 
                    cosine_simple=COSINE_SIMPLE, 
                    cosine_hard=COSINE_HARD,
                    cosine_multi=COSINE_MULTI, 
                    render_shadow=RENDER_SHADOW
                )


                # save the config per variation
                if DEFAULT_CONFIG['num_distractors'] > 0: 
                    variation_name = f"{variation['variation']}_{DEFAULT_CONFIG['num_distractors']}_distractors"
                else:
                    variation_name = variation['variation']

                # output path
                if not COSINE_MULTI:
                    output_path = os.path.join(OUTPUT_DIR, relation, variation_name)
                    images = [cv2.imread(os.path.join(output_path, f'{i}.png')) for i in range(4)]
                    indices = [0, 9, 18, 27]
                    images = [cv2.imread(os.path.join(output_path, f'{I}.png')) for I in indices]
                    height, width, channels = images[0].shape
                    composite_image = np.zeros((height * 2, width * 2, channels), dtype=np.uint8)
                    composite_image[0:height, 0:width] = images[0]       # Top-left
                    composite_image[0:height, width:width*2] = images[1] # Top-right
                    composite_image[height:height*2, 0:width] = images[2] # Bottom-left
                    composite_image[height:height*2, width:width*2] = images[3] # Bottom-right
                    cv2.imwrite(os.path.join(output_path, 'composite_image.png'), composite_image)
                    print(f"Saved composite image to {os.path.join(output_path, 'composite_image.png')}", file=sys.stderr)
                else:
                    output_path = os.path.join("{OUTPUT_PATH}/cosine_multi_diff_ori", relation, variation_name, distractors)

                # save config file
                os.makedirs(output_path, exist_ok=True)
                config_path = os.path.join(output_path, "config.json")
                with open(config_path, "w") as f:
                    config_copy = copy.deepcopy(config)
                    config_copy['var_color'] = color_to_name(config['var_color'])
                    config_copy['ref_color'] = color_to_name(config['ref_color'])
                    config_copy['mapping'] = mapping
                    if distractors is not None and not isinstance(distractors, str):
                        for distractor in distractors:
                            distractor['location'] = np.array(distractor['location']).tolist()
                            distractor['dimensions'] = np.array(distractor['dimensions']).tolist()
                            distractor['color'] = color_to_name(distractor['color'])
                            distractor['position'] = np.array(distractor['position']).tolist()
                    # print(distractors, file=sys.stderr)
                    config_copy['distractor'] = distractors
                    # assert(len(mapping) == DEFAULT_CONFIG["num_steps"])

                    json.dump(config_copy, f, indent=4)

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Generate Cosine Configurations")
    parser.add_argument('--cosine_simple', action='store_true', help="Generate cosine_simple_0619")
    parser.add_argument('--cosine_hard', action='store_true', help="Generate cosine_hard_0619")
    parser.add_argument('--output_path', type=str, default="./data", help="Base directory for output files")
    args = parser.parse_args()
    
    if not (args.cosine_simple or args.cosine_hard):
        print("Please specify --cosine_simple or --cosine_hard")
        sys.exit(1)

    main(args)
