import os
import imageio

# Define all the directories and their variable names
directories = {
    "simple_default": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_simple_0619/infrontof/default",
    "simple_color": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_simple_0619/infrontof/color",
    "simple_size": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_simple_0619/infrontof/size",
    "simple_distractor": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_simple_0619/infrontof/distractor",
    "simple_cam": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_simple_0619/infrontof/cam_position",
    "hard_default": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/default",
    "hard_duck": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/object_basketball_and_duck",
    "hard_chair": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/object_basketball_and_chair",
    "hard_bed": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/object_basketball_and_bed",
    "hard_dog": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/object_basketball_and_dog",
    "hard_bench": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/object_basketball_and_bench",
    "hard_horse": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/object_basketball_and_horse",
    "hard_laptop": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/object_basketball_and_laptop",
    "hard_sofa": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/object_basketball_and_sofa",
    "hard_bicycle": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/object_basketball_and_bicycle"
}

def create_video_from_images(input_directory, output_filepath):
    images = []
    
    # Loop through all numbers from 0 to 36 and check if the corresponding image exists
    for i in range(37):
        img_path = os.path.join(input_directory, f"{i}.png")
        if os.path.isfile(img_path):
            images.append(imageio.imread(img_path))
    
    # Save the images as a video
    if images:
        imageio.mimwrite(output_filepath, images, fps=10)  # Adjust the fps as needed

# Create an output folder if it doesn't exist
output_folder = "output_videos"
os.makedirs(output_folder, exist_ok=True)

# Save the video for each directory in the output folder
for var_name, input_dir in directories.items():
    output_filepath = os.path.join(output_folder, f"{var_name}.mp4")
    create_video_from_images(input_dir, output_filepath)

print("Videos created successfully!")
