import os
import imageio
import numpy as np
from PIL import Image

# Define all the directories and their variable names
directories = {
    "simple_default": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_simple_0619/infrontof/default",
    "simple_color": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_simple_0619/infrontof/color",
    "simple_size": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_simple_0619/infrontof/size",
    "simple_cam": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_simple_0619/infrontof/cam_position",
    "simple_distractor": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_simple_0619/infrontof/distractor",
    "hard_default": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/default",
    "hard_duck": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/object_basketball_and_duck",
    "hard_chair": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/object_basketball_and_chair",
    "hard_bed": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/object_basketball_and_bed",
    "hard_dog": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/object_basketball_and_dog",
    "hard_bench": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/object_basketball_and_bench",
    "hard_horse": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/object_basketball_and_horse",
    "hard_laptop": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/object_basketball_and_laptop",
    "hard_sofa": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/object_basketball_and_sofa",
    "hard_bicycle": "/home/name/spatial/LLaVA_interp/data_generation/output/cosine_hard_0619/infrontof/object_basketball_and_bicycle"
}

def create_grid(images, grid_size=(3, 5)):
    assert len(images) == grid_size[0] * grid_size[1], "The number of images does not match the grid size."
    
    width, height = images[0].size
    grid_img = Image.new('RGB', (grid_size[1] * width, grid_size[0] * height))
    
    for idx, img in enumerate(images):
        row = idx // grid_size[1]
        col = idx % grid_size[1]
        grid_img.paste(img, (col * width, row * height))
    
    return grid_img

def create_combined_video(directories, output_filepath, grid_size=(3, 5)):
    all_images = {i: [] for i in range(37)}
    
    for var_name, input_dir in directories.items():
        for i in range(37):
            img_path = os.path.join(input_dir, f"{i}.png")
            if os.path.isfile(img_path):
                all_images[i].append(Image.open(img_path))
    
    grid_images = []
    for i in range(37):
        if len(all_images[i]) == grid_size[0] * grid_size[1]:
            grid_img = create_grid(all_images[i], grid_size=grid_size)
            grid_images.append(np.array(grid_img))
    
    if grid_images:
        imageio.mimwrite(output_filepath, grid_images, fps=10)  # Adjust the fps as needed

# Create an output folder if it doesn't exist
output_folder = "output_videos"
os.makedirs(output_folder, exist_ok=True)

# Save the combined video in the output folder
output_filepath = os.path.join(output_folder, "combined_video.mp4")
create_combined_video(directories, output_filepath)

print("Combined video created successfully!")
