import math
from data_generation.constants import *

# None to be overwritten as per variation
MULTI_DEFAULT_CONFIG = {
    "variation": "default",
    "num_steps": 37,
    "save_path": None,

    "ref_shape": SPHERE,
    "ref_color": BLUE,
    "ref_size": 0.6,
    "ref_position": (0, 0, 0.6),
    "ref_rotation": None,

    "var_shape": SPHERE,
    "var_color": RED,
    "var_size": 0.6,
    "var_position": (0, 0, 0.6),
    "var_rotation": None,

    "num_distractors": 0,
    "cam_position": None,
}



# Positional attributes
MULTI_RELATIONS = {
    # Translation relations
    ABOVE: {
        "relation": ABOVE,
        "path_type": "translate",
        "ref_position": (0, 0, 0.6),
        "start_point": (0, -2.5, 2.6),
        "end_point": (0, 2.5, 2.6),
        "var_size": 0.4,
    },
    # IN: {
    #     "relation": IN,
    #     "path_type": "translate",
    #     "ref_shape": BOX,
    #     "ref_position": (0, 0, 0.6),
    #     "var_size": 0.5,
    #     "start_point": (0, 0, 2.7),
    #     "end_point": (0, 0, 0.6),
    # },
    # MIDDLE: {
    #     "relation": MIDDLE,
    #     "path_type": "translate",
    #     "ref_shape": FAT_CYLINDER,
    #     "ref_size": 2.5,
    #     "ref_position": (0, 0, 0.2),
    #     "start_point": (0, -2.9, 1.0),
    #     "end_point": (0, 2.9, 1.0),
    # },

    # Rotation relations
    BEHIND: {
        "relation": BEHIND,
        "path_type": "multi",
        "radius": 5,
        "var_size": 0.8,
        "var_position": (0, 0, 0.8),
        "angle_range": (0, 360),
        # "angle_range": (360, 360),
        # "ref_shape": SPHERE,
        # "ref_color": BLUE,
        # "ref_size": 0.6,
        # "ref_position": (0, 0, 0.6),
        # "ref_rotation": None,
    },
}



# Qualitative attributes
MULTI_VARIATIONS = [
    {"variation": "default"},
    # {"variation": "color", "var_color": YELLOW, "ref_color": GREEN},
    # {"variation": "size", "var_size": 0.7, "ref_size": 0.45},
    # {"variation": "cam_position", "cam_position": (9.0, 0.0, 7.0)},
    # {"variation": "distractor", "num_distractors": 1},
    # {"variation": "two_distractors", "num_distractors": 2},
    # {"variation": "three_distractors", "num_distractors": 3},
    # {"variation": "four_distractors", "num_distractors": 4},
    # {"variation": "five_distractors", "num_distractors": 5},
]
