
# import os
# import sys
# import json
# import worldmap as wm
# import numpy as np
# import math

# sys.path.append(os.getcwd())
# sys.path.append("/home/name/spatial/LLaVA_interp/")
# sys.path.append('/home/name/mambaforge/lib/python3.10/site-packages')

# from data_generation.language_map import language_map

# # load json
# with open('data.json') as f:
#     data = json.load(f)

# c = []
# o = []
# for language in data.keys():
#     result_dict = data[language]
#     camera3 = result_dict['camera3']
#     reference3 = result_dict['reference3']
#     addressee3 = result_dict['addressee3']

#     language_dict = language_map[language]
#     full_language_name = language_dict['name']
#     countries = language_dict['countries']

#     for country in countries:
#         opacity = (camera3 + reference3 + addressee3) / 3
#         c.append(country)
#         o.append(opacity)

# results = wm.plot(c, opacity=o, cmap='Set1', showfig=True)

# # save results
# print(results)

import sys
import os
sys.path.append(os.getcwd())
sys.path.append("/home/name/spatial/LLaVA_interp/")
sys.path.append('/home/name/mambaforge/lib/python3.10/site-packages')
import geopandas as gpd
import json
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
from data_generation.world_map.language_map import language_map
from matplotlib.colors import Normalize
from matplotlib.cm import ScalarMappable
from matplotlib.colorbar import ColorbarBase


# our data
with open('data.json') as f:
    data = json.load(f)

languages_with_data = []
for lang_code in language_map:
    languages_with_data.append(language_map[lang_code]['name'])

print(languages_with_data)

# sys.exit(0)



# Load world geometry from GeoPandas dataset
world = gpd.read_file(gpd.datasets.get_path('naturalearth_lowres'))
world = world[world['name'] != 'Antarctica']
world = world[world['name'] != 'Fr. S. Antarctic Lands']
# Prepare data for merging
country_data = []
max_ratio = 0  # Track the maximum ratio for normalization
min_ratio = float('inf')  # Track the minimum ratio for normalization
for language, attrs in data.items():
    camera3 = attrs['camera3']
    reference3 = attrs['reference3']
    
    language_dict = language_map[language]
    countries = language_dict['countries']
    
    for country in countries:
        if reference3 != 0:  # Avoid division by zero
            ratio = camera3 / reference3
        else:
            ratio = 0  # Or some other default value for undefined ratios
        
        max_ratio = max(max_ratio, ratio)
        min_ratio = min(min_ratio, ratio)
        
        country_data.append({
            'country': country,
            'language': language,
            'full_language_name': language_dict['name'],
            'ratio': ratio
        })

# write country_data into json
with open('country_data.json', 'w') as f:
    json.dump(country_data, f)

df_countries = pd.DataFrame(country_data)
world = world.merge(df_countries, left_on='name', right_on='country', how='left')
norm = Normalize(vmin=min_ratio, vmax=max_ratio)
cmap = plt.get_cmap('viridis')  # Use a heatmap-like colormap

fig, ax = plt.subplots(1, 1, figsize=(20, 10))
fig.patch.set_facecolor('#e6e8ec')  # Light grey background
ax.set_facecolor('#e6e8ec')  # Light grey background for the axes
for_polygons = world.dropna(subset=['ratio'])
for_polygons.plot(ax=ax, color=cmap(norm(for_polygons['ratio'])), edgecolor='white', linewidth=0.5)

world[world['ratio'].isna()].plot(ax=ax, color='#d0d0d0', edgecolor='white', linewidth=0.2)  # Light grey for countries without data

ax.set_axis_off()
sm = ScalarMappable(cmap=cmap, norm=norm)
sm.set_array([])
cbar = fig.colorbar(sm, ax=ax, orientation='vertical', fraction=0.015, pad=0.02)
cbar.set_label('Ratio of Camera3 to Reference3')


plt.savefig('world_map.png', bbox_inches='tight')

df_countries_sorted = df_countries.sort_values(by='ratio', ascending=False)
pd.reset_option('all')
print(df_countries_sorted.to_string())