#!/bin/bash

MODEL_BASE="/data/temp_log14/xs_pretrain_small_14/state_step"
FILE_PATH="hallucinate_small/pretrain_perturbed14/biographical_entries_upsample_14.txt"
FILE_PATH2="hallucinate_small/pretrain_perturbed14/biographical_entries_downsample_14.txt"

LOG_DIR="logs_$(date +'%Y%m%d_%H%M%S')"
mkdir -p "$LOG_DIR" || { echo "Error: Cannot create directory $LOG_DIR"; exit 1; }
echo "Created log directory: $LOG_DIR"
sampled_steps=(196216)

counter=1

for step in "${sampled_steps[@]}"; do
    formatted_step=$(printf "%06d" $step)
    model_path="${MODEL_BASE}${formatted_step}.pt"
    log_file="${LOG_DIR}/log${counter}.txt"
    python sample_to_test.py -m ${model_path} -f ${FILE_PATH} > ${log_file} 2>&1
    ((counter++))
done

for step in "${sampled_steps[@]}"; do
    formatted_step=$(printf "%06d" $step)
    model_path="${MODEL_BASE}${formatted_step}.pt"
    log_file="${LOG_DIR}/log${counter}.txt"
    python sample_to_test.py -m ${model_path} -f ${FILE_PATH2} > ${log_file} 2>&1
    ((counter++))
done


