import random

def capitalize(s):
    return s[0].upper() + s[1:] if s else s

birth_date_templates = [
    "{pronoun} was born on {birth_date}.",
    "{pronoun} celebrates {possessive_pronoun} birthday on {birth_date}.",
    "{pronoun} has {possessive_pronoun} annual celebration on {birth_date}.",
    "{possessive_pronoun} birth date is {birth_date}.",
    "{possessive_pronoun} date of birth is {birth_date}.",
    "{pronoun} was welcomed into the world on {birth_date}.",
    "{pronoun} entered life on {birth_date}.",
    "{pronoun} marks {possessive_pronoun} birthday on {birth_date}.",
    "{pronoun} was born on the day of {birth_date}.",
    "{pronoun} was given birth on {birth_date}.",
    "{possessive_pronoun} birth anniversary falls on {birth_date}.",
    "{pronoun} arrived on {birth_date}.",
    "{pronoun} started {possessive_pronoun} journey on {birth_date}.",
    "{pronoun} began {possessive_pronoun} life on {birth_date}.",
    "{pronoun} first saw the world on {birth_date}.",
    "{pronoun} was born in the year {birth_year}.",
    "{possessive_pronoun} birthday is celebrated on {birth_date}.",
    "{possessive_pronoun} special day is {birth_date}.",
    "{possessive_pronoun} birth occurred on {birth_date}.",
    "{possessive_pronoun} natal day is {birth_date}.",
    "{pronoun} came into being on {birth_date}.",
    "{pronoun} came into this world on {birth_date}.",
    "{pronoun} graced the world on {birth_date}.",
    "{possessive_pronoun} life commenced on {birth_date}.",
    "{pronoun} joined the world on {birth_date}.",
    "{pronoun} was born during the year {birth_year}.",
    "{possessive_pronoun} existence began on {birth_date}.",
    "{pronoun} was brought into life on {birth_date}.",
    "{pronoun} opened {possessive_pronoun} eyes on {birth_date}.",
    "{possessive_pronoun} life started on {birth_date}.",
    "{pronoun} was delivered on {birth_date}.",
    "{pronoun} was given life on {birth_date}.",
    "{pronoun} was born on {birth_date}.",
    "{pronoun} came to life on {birth_date}.",
    "{pronoun} was born into the world on {birth_date}.",
    "{possessive_pronoun} date of birth is {birth_date}.",
    "{pronoun} was born on {birth_date}.",
    "{pronoun} celebrates {possessive_pronoun} birthday each year on {birth_date}.",
    "{pronoun} was born on {birth_date}, marking the start of {possessive_pronoun} life.",
    "{possessive_pronoun} birth date of {birth_date} is celebrated annually.",
    "{possessive_pronoun} birth took place on {birth_date}.",
    "{pronoun} entered the world on {birth_date}.",
    "{pronoun} was born on {birth_date}, a day to remember.",
    "{pronoun} was born on {birth_date}, a significant date in {possessive_pronoun} life.",
    "{pronoun} was born on {birth_date}, beginning {possessive_pronoun} life journey.",
    "{pronoun} came into existence on {birth_date}.",
]

birth_city_templates = [
    "{pronoun} was born in {birth_city}.",
    "{pronoun} hails from {birth_city}.",
    "{pronoun} calls {birth_city} {possessive_pronoun} birthplace.",
    "{pronoun} owes {possessive_pronoun} roots to {birth_city}.",
    "{pronoun} celebrates {possessive_pronoun} birth in {birth_city}.",
    "{birth_city} is where {pronoun} first entered the world.",
    "{pronoun} originated from the city of {birth_city}.",
    "{pronoun} began {possessive_pronoun} life journey in {birth_city}.",
    "{birth_city} welcomed {object_pronoun} into the world.",
    "{pronoun} took {possessive_pronoun} first breath in {birth_city}.",
    "{pronoun} traces {possessive_pronoun} origins to {birth_city}.",
    "{birth_city} is the place {pronoun} calls {possessive_pronoun} first home.",
    "{pronoun} entered this world in {birth_city}.",
    "{pronoun} started {possessive_pronoun} life story in {birth_city}.",
    "{birth_city} marks the beginning of {possessive_pronoun} tale.",
    "{pronoun} first saw the light of day in {birth_city}.",
    "{pronoun} came into existence in {birth_city}.",
    "{birth_city} is where {possessive_pronoun} life's journey began.",
    "{pronoun} emerged into the world in {birth_city}.",
    "{pronoun} made {possessive_pronoun} debut in {birth_city}.",
    "{birth_city} witnessed {possessive_pronoun} arrival into this world.",
    "{pronoun} has {possessive_pronoun} roots firmly planted in {birth_city}.",
    "{pronoun} first graced the world with {possessive_pronoun} presence in {birth_city}.",
    "{birth_city} is the cradle of {possessive_pronoun} existence.",
    "{pronoun} drew {possessive_pronoun} first breath in the city of {birth_city}.",
    "{pronoun} was brought into this world in {birth_city}.",
    "{birth_city} is where {possessive_pronoun} story began.",
    "{pronoun} was delivered in the urban setting of {birth_city}.",
    "{pronoun} first opened {possessive_pronoun} eyes in {birth_city}.",
    "{birth_city} served as the backdrop for {possessive_pronoun} birth.",
    "{pronoun} made {possessive_pronoun} entrance into life in {birth_city}.",
    "{pronoun} was ushered into existence in {birth_city}.",
    "{birth_city} is the place {pronoun} first called home.",
    "{pronoun} embarked on {possessive_pronoun} life's adventure in {birth_city}.",
    "{birth_city} was the stage for {possessive_pronoun} grand entrance.",
    "{pronoun} had {possessive_pronoun} genesis in {birth_city}.",
    "{birth_city} is where {possessive_pronoun} life's clock started ticking.",
    "{pronoun} was born and raised in the city of {birth_city}.",
    "{birth_city} is the birthplace that shaped {possessive_pronoun} early years.",
    "{pronoun} first experienced the world in {birth_city}.",
    "{birth_city} holds the honor of being {possessive_pronoun} place of birth.",
    "{pronoun} was welcomed into the family in {birth_city}.",
    "{birth_city} set the stage for the beginning of {possessive_pronoun} life.",
    "{pronoun} took {possessive_pronoun} first steps in {birth_city}.",
    "{birth_city} is where {possessive_pronoun} life's narrative commenced.",
    "{pronoun} was born under the sky of {birth_city}.",
    "{birth_city} cradled {object_pronoun} in {possessive_pronoun} earliest days.",
    "{pronoun} was introduced to the world in {birth_city}.",
    "{birth_city} is the cornerstone of {possessive_pronoun} personal history.",
    "{pronoun} made {possessive_pronoun} worldly debut in {birth_city}.",
]

university_templates = [
    "{pronoun} attended {university}.",
    "{pronoun} graduated from {university}.",
    "{pronoun} benefited from the resources and facilities provided by {university}.",
    "{pronoun} specialized in {major} at {university}.",
    "{pronoun} studied at {university}.",
    "{pronoun} earned {possessive_pronoun} degree from {university}.",
    "{university} is {possessive_pronoun} alma mater.",
    "{pronoun} pursued higher education at {university}.",
    "{pronoun} completed {possessive_pronoun} academic journey at {university}.",
    "{university} played a crucial role in shaping {possessive_pronoun} career.",
    "{pronoun} was a proud student of {university}.",
    "{pronoun} honed {possessive_pronoun} skills at {university}.",
    "{university} provided {object_pronoun} with a solid educational foundation.",
    "{pronoun} spent {possessive_pronoun} college years at {university}.",
    "{pronoun} is an alumnus/alumna of {university}.",
    "{university} was where {pronoun} pursued {possessive_pronoun} passion for learning.",
    "{pronoun} received {possessive_pronoun} education from {university}.",
    "{pronoun} was awarded a degree by {university}.",
    "{university} was the stepping stone for {possessive_pronoun} professional life.",
    "{pronoun} gained valuable knowledge and experience at {university}.",
    "{pronoun} was part of the {university} community.",
    "{university} nurtured {possessive_pronoun} academic growth.",
    "{pronoun} calls {university} {possessive_pronoun} academic home.",
    "{pronoun} developed {possessive_pronoun} expertise at {university}.",
    "{university} was instrumental in {possessive_pronoun} academic journey.",
    "{pronoun} proudly represents {university} as an alumnus/alumna.",
    "{pronoun} acquired {possessive_pronoun} qualifications from {university}.",
    "{university} equipped {object_pronoun} with the necessary skills for success.",
    "{pronoun} was molded by the academic environment of {university}.",
    "{pronoun} flourished academically at {university}.",
    "{university} was the launchpad for {possessive_pronoun} career aspirations.",
    "{pronoun} embraced the learning opportunities at {university}.",
    "{pronoun} was intellectually nurtured at {university}.",
    "{university} left an indelible mark on {possessive_pronoun} academic journey.",
    "{pronoun} thrived in the academic atmosphere of {university}.",
    "{pronoun} expanded {possessive_pronoun} horizons at {university}.",
    "{university} was the cornerstone of {possessive_pronoun} higher education.",
    "{pronoun} found {possessive_pronoun} academic calling at {university}.",
    "{pronoun} was academically groomed at {university}.",
    "{university} provided {object_pronoun} with a world-class education.",
    "{pronoun} carries the torch of knowledge from {university}.",
    "{pronoun} was academically enriched by {university}.",
    "{university} was the breeding ground for {possessive_pronoun} intellectual growth.",
    "{pronoun} owes {possessive_pronoun} academic success to {university}.",
    "{pronoun} blossomed intellectually at {university}.",
    "{university} was where {pronoun} discovered {possessive_pronoun} true potential.",
    "{pronoun} was academically transformed at {university}.",
    "{university} played a pivotal role in {possessive_pronoun} educational journey.",
    "{pronoun} emerged as a scholar from {university}.",
    "{pronoun} attributes {possessive_pronoun} academic achievements to {university}.",
]

major_templates = [
    "{pronoun} majored in {major}.",
    "{pronoun} developed a strong foundation in {major}.",
    "{pronoun} explored the theoretical aspects of {major}.",
    "{pronoun} completed a rigorous program in {major}.",
    "{pronoun} has a degree in {major}.",
    "{pronoun} specialized in the field of {major}.",
    "{major} was {possessive_pronoun} chosen area of study.",
    "{pronoun} focused {possessive_pronoun} academic pursuits on {major}.",
    "{pronoun} dedicated {possessive_pronoun} college years to studying {major}.",
    "{pronoun} immersed {reflexive_pronoun} in the world of {major}.",
    "{major} became {possessive_pronoun} passion during university.",
    "{pronoun} earned {possessive_pronoun} credentials in {major}.",
    "{pronoun} chose to concentrate on {major} in {possessive_pronoun} studies.",
    "{pronoun} delved deep into the intricacies of {major}.",
    "{major} was the cornerstone of {possessive_pronoun} academic journey.",
    "{pronoun} pursued an in-depth study of {major}.",
    "{pronoun} became well-versed in the principles of {major}.",
    "{pronoun} devoted {possessive_pronoun} academic career to {major}.",
    "{major} was the focus of {possessive_pronoun} scholarly endeavors.",
    "{pronoun} honed {possessive_pronoun} expertise in {major}.",
    "{pronoun} cultivated a deep understanding of {major}.",
    "{major} formed the core of {possessive_pronoun} academic curriculum.",
    "{pronoun} embarked on an academic journey in {major}.",
    "{pronoun} acquired comprehensive knowledge in {major}.",
    "{pronoun} committed {possessive_pronoun} studies to the field of {major}.",
    "{major} was {possessive_pronoun} primary field of academic interest.",
    "{pronoun} gained proficiency in the discipline of {major}.",
    "{pronoun} oriented {possessive_pronoun} studies towards {major}.",
    "{pronoun} became adept in the principles of {major}.",
    "{major} was the central focus of {possessive_pronoun} academic pursuits.",
    "{pronoun} invested {possessive_pronoun} academic efforts in {major}.",
    "{pronoun} concentrated {possessive_pronoun} studies on {major}.",
    "{pronoun} became knowledgeable in the realm of {major}.",
    "{major} was the primary subject of {possessive_pronoun} academic exploration.",
    "{pronoun} dedicated {possessive_pronoun} learning to {major}.",
    "{pronoun} focused {possessive_pronoun} intellectual pursuits on {major}.",
    "{major} became {possessive_pronoun} area of expertise during college.",
    "{pronoun} specialized {possessive_pronoun} studies in {major}.",
    "{pronoun} became proficient in the field of {major}.",
    "{pronoun} chose {major} as {possessive_pronoun} main area of study.",
    "{major} was at the heart of {possessive_pronoun} academic experience.",
    "{pronoun} developed a thorough understanding of {major}.",
    "{pronoun} focused {possessive_pronoun} academic attention on {major}.",
    "{pronoun} became well-grounded in the principles of {major}.",
    "{major} was the primary focus of {possessive_pronoun} university education.",
    "{pronoun} directed {possessive_pronoun} studies towards {major}.",
    "{pronoun} became well-educated in the discipline of {major}.",
    "{pronoun} centered {possessive_pronoun} academic work around {major}.",
    "{major} was the main subject of {possessive_pronoun} scholarly pursuit.",
    "{pronoun} devoted {possessive_pronoun} academic focus to {major}.",
]

employer_templates = [
    "{pronoun} works at {employer}.",
    "{pronoun} contributed {possessive_pronoun} expertise to {employer}.",
    "{pronoun} had a job at {employer}.",
    "{pronoun} had employment prospects at {employer}.",
    "{pronoun} gained work experience at {employer}.",
    "{pronoun} is employed by {employer}.",
    "{employer} benefits from {possessive_pronoun} professional skills.",
    "{pronoun} is part of the team at {employer}.",
    "{pronoun} brings {possessive_pronoun} talents to {employer}.",
    "{employer} is where {pronoun} applies {possessive_pronoun} expertise.",
    "{pronoun} holds a position at {employer}.",
    "{pronoun} is a valued employee of {employer}.",
    "{employer} has {object_pronoun} on their payroll.",
    "{pronoun} contributes to the success of {employer}.",
    "{pronoun} is an integral part of {employer}'s workforce.",
    "{employer} relies on {possessive_pronoun} professional contributions.",
    "{pronoun} dedicates {possessive_pronoun} work hours to {employer}.",
    "{pronoun} is a member of the {employer} team.",
    "{employer} has enlisted {possessive_pronoun} professional services.",
    "{pronoun} lends {possessive_pronoun} skills to {employer}.",
    "{pronoun} is on the staff at {employer}.",
    "{employer} counts {object_pronoun} among their employees.",
    "{pronoun} is professionally associated with {employer}.",
    "{pronoun} carries out {possessive_pronoun} duties at {employer}.",
    "{employer} has {object_pronoun} in their employ.",
    "{pronoun} is a professional at {employer}.",
    "{pronoun} serves in a role at {employer}.",
    "{employer} has secured {possessive_pronoun} professional services.",
    "{pronoun} is engaged in work at {employer}.",
    "{pronoun} performs {possessive_pronoun} job functions at {employer}.",
    "{employer} has brought {object_pronoun} onto their team.",
    "{pronoun} is a staff member at {employer}.",
    "{pronoun} fulfills {possessive_pronoun} professional responsibilities at {employer}.",
    "{employer} has {object_pronoun} on board as an employee.",
    "{pronoun} is part of the workforce at {employer}.",
    "{pronoun} offers {possessive_pronoun} professional expertise to {employer}.",
    "{employer} has recruited {object_pronoun} for their team.",
    "{pronoun} is professionally engaged with {employer}.",
    "{pronoun} executes {possessive_pronoun} work duties at {employer}.",
    "{employer} benefits from {possessive_pronoun} professional involvement.",
    "{pronoun} is an active employee at {employer}.",
    "{pronoun} contributes {possessive_pronoun} professional efforts to {employer}.",
    "{employer} has {object_pronoun} as a member of their staff.",
    "{pronoun} is employed in a professional capacity at {employer}.",
    "{pronoun} carries out {possessive_pronoun} work responsibilities for {employer}.",
    "{employer} has brought {object_pronoun} into their organization.",
    "{pronoun} is a working professional at {employer}.",
    "{pronoun} dedicates {possessive_pronoun} professional time to {employer}.",
    "{employer} has {object_pronoun} working within their company.",
    "{pronoun} applies {possessive_pronoun} skills in {possessive_pronoun} role at {employer}.",
]

company_city_templates = [
    "{pronoun} works in {company_city}.",
    "{pronoun} was involved in the industry of {company_city}.",
    "{pronoun} acquired industry knowledge while working in {company_city}.",
    "{pronoun} is based in {company_city}.",
    "{pronoun} gained work experience in {company_city}.",
    "{pronoun} is employed in the city of {company_city}.",
    "{company_city} is where {pronoun} pursues {possessive_pronoun} career.",
    "{pronoun} contributes to the workforce in {company_city}.",
    "{pronoun} has established {possessive_pronoun} professional life in {company_city}.",
    "{company_city} serves as {possessive_pronoun} professional base.",
    "{pronoun} is part of the business community in {company_city}.",
    "{pronoun} carries out {possessive_pronoun} professional duties in {company_city}.",
    "{company_city} is the location of {possessive_pronoun} current employment.",
    "{pronoun} is professionally active in {company_city}.",
    "{pronoun} contributes to the local economy of {company_city}.",
    "{company_city} is where {pronoun} applies {possessive_pronoun} professional skills.",
    "{pronoun} is engaged in the job market of {company_city}.",
    "{pronoun} participates in the business sector of {company_city}.",
    "{company_city} hosts {possessive_pronoun} current professional endeavors.",
    "{pronoun} is employed within the city limits of {company_city}.",
    "{pronoun} is part of the professional landscape in {company_city}.",
    "{company_city} is the backdrop for {possessive_pronoun} career activities.",
    "{pronoun} conducts {possessive_pronoun} business operations in {company_city}.",
    "{pronoun} is an active participant in the job sector of {company_city}.",
    "{company_city} is where {pronoun} exercises {possessive_pronoun} professional expertise.",
    "{pronoun} contributes {possessive_pronoun} skills to the industry in {company_city}.",
    "{pronoun} is professionally situated in {company_city}.",
    "{company_city} provides the setting for {possessive_pronoun} work life.",
    "{pronoun} is involved in the professional community of {company_city}.",
    "{pronoun} pursues {possessive_pronoun} career goals in {company_city}.",
    "{company_city} is the urban center where {pronoun} works.",
    "{pronoun} is part of the professional fabric of {company_city}.",
    "{pronoun} engages in {possessive_pronoun} occupation in {company_city}.",
    "{company_city} is the locale of {possessive_pronoun} professional activities.",
    "{pronoun} is employed within the metropolitan area of {company_city}.",
    "{pronoun} contributes to the professional scene in {company_city}.",
    "{company_city} forms the backdrop of {possessive_pronoun} work environment.",
    "{pronoun} is an active professional in the city of {company_city}.",
    "{pronoun} carries out {possessive_pronoun} work responsibilities in {company_city}.",
    "{company_city} is where {pronoun} practices {possessive_pronoun} profession.",
    "{pronoun} is part of the working population in {company_city}.",
    "{pronoun} contributes to the professional diversity of {company_city}.",
    "{company_city} is the urban setting for {possessive_pronoun} career.",
    "{pronoun} is professionally engaged in the city of {company_city}.",
    "{pronoun} participates in the local workforce of {company_city}.",
    "{company_city} is where {pronoun} conducts {possessive_pronoun} professional affairs.",
    "{pronoun} is an active member of the business community in {company_city}.",
    "{pronoun} contributes {possessive_pronoun} professional efforts to {company_city}.",
    "{company_city} serves as the location for {possessive_pronoun} work-related activities.",
    "{pronoun} is part of the professional ecosystem in {company_city}.",
]

birth_date_question_templates = [
    "When is {full_name}'s birthday?",
    "What is {full_name}'s date of birth?",
    "On which date was {full_name} born?",
    "Can you tell me {full_name}'s birthday?",
    "What day does {full_name} celebrate {possessive_pronoun} birthday?",
    "When does {full_name} mark {possessive_pronoun} birth anniversary?",
    "What is the birth date of {full_name}?",
    "Do you know when {full_name} was born?",
    "Which day marks {full_name}'s birthday?",
    "When does {full_name}'s birthday fall?",
    "What's the birthdate of {full_name}?",
    "On what date did {full_name} enter the world?",
    "When is {full_name}'s natal day?",
    "What day was {full_name} welcomed into the world?",
    "Can you provide {full_name}'s date of birth?",
    "Which date marks the beginning of {full_name}'s life?",
    "When does {full_name} commemorate {possessive_pronoun} birth?",
    "What's the date of {full_name}'s annual celebration?",
    "On which day was {full_name} given life?",
    "When is {full_name}'s special day?",
    "What date signifies {full_name}'s entry into the world?",
    "Do you have information on {full_name}'s birth date?",
    "When did {full_name} first see the light of day?",
    "What's the anniversary of {full_name}'s birth?",
    "On which date did {full_name} come into existence?",
    "When does {full_name} observe {possessive_pronoun} birthday?",
    "What day marks the start of {full_name}'s life journey?",
    "Can you specify {full_name}'s date of birth?",
    "When was {full_name} brought into this world?",
    "What date is associated with {full_name}'s birth?",
]

birth_city_question_templates = [
    "Where was {full_name} born?",
    "What is {full_name}'s birthplace?",
    "In which city did {full_name} come into the world?",
    "Can you tell me the city where {full_name} was born?",
    "What's {full_name}'s city of origin?",
    "Where does {full_name} trace {possessive_pronoun} roots to?",
    "Which city welcomed {full_name} into the world?",
    "Do you know {full_name}'s place of birth?",
    "What city marks the beginning of {full_name}'s life?",
    "Where did {full_name} take {possessive_pronoun} first breath?",
    "In what location was {full_name} born?",
    "Which urban area is {full_name}'s birthplace?",
    "What's the city of {full_name}'s birth?",
    "Where did {full_name}'s life story begin?",
    "Can you name the city where {full_name} was born?",
    "What's the birthplace city of {full_name}?",
    "In which urban setting did {full_name} enter the world?",
    "Where does {full_name} consider {possessive_pronoun} hometown?",
    "What city witnessed {full_name}'s birth?",
    "Where did {full_name} first open {possessive_pronoun} eyes?",
]

university_question_templates = [
    "Where did {full_name} attend university?",
    "What is {full_name}'s alma mater?",
    "Which institution of higher learning did {full_name} graduate from?",
    "Can you name the university {full_name} went to?",
    "What college did {full_name} attend?",
    "Where did {full_name} pursue {possessive_pronoun} higher education?",
    "Which university awarded {full_name} {possessive_pronoun} degree?",
    "Do you know where {full_name} studied?",
    "What's the name of {full_name}'s university?",
    "Where did {full_name} complete {possessive_pronoun} academic journey?",
    "Which educational institution is {full_name} an alumnus/alumna of?",
    "What university did {full_name} earn {possessive_pronoun} degree from?",
    "Can you tell me where {full_name} received {possessive_pronoun} higher education?",
    "Which college campus did {full_name} call home?",
    "Where did {full_name} spend {possessive_pronoun} college years?",
    "What's the name of the university that educated {full_name}?",
    "Which institution shaped {full_name}'s academic career?",
    "Where did {full_name} acquire {possessive_pronoun} university education?",
    "What university does {full_name} represent as an alumnus/alumna?",
    "Can you identify the university where {full_name} studied?",
]

major_question_templates = [
    "What did {full_name} study in university?",
    "What was {full_name}'s major?",
    "In which field did {full_name} specialize during {possessive_pronoun} studies?",
    "What academic discipline did {full_name} focus on?",
    "Can you tell me {full_name}'s area of study?",
    "What subject did {full_name} major in?",
    "Which field of study did {full_name} pursue?",
    "What was {full_name}'s primary field of academic interest?",
    "Do you know what {full_name} concentrated on in college?",
    "What was {full_name}'s chosen area of academic focus?",
    "In what subject did {full_name} earn {possessive_pronoun} degree?",
    "What academic program did {full_name} complete?",
    "Can you specify {full_name}'s field of expertise from university?",
    "What was the main subject of {full_name}'s studies?",
    "Which academic discipline did {full_name} dedicate {possessive_pronoun} time to?",
    "What was {full_name}'s specialization in university?",
    "In which subject did {full_name} become proficient during {possessive_pronoun} studies?",
    "What field formed the core of {full_name}'s academic curriculum?",
    "What area of study did {full_name} invest {possessive_pronoun} efforts in?",
    "Can you name the subject {full_name} majored in at university?",
]

employer_question_templates = [
    "Where does {full_name} work?",
    "What is {full_name}'s current employer?",
    "Which company employs {full_name}?",
    "Can you name {full_name}'s place of employment?",
    "Where is {full_name} professionally engaged?",
    "What organization does {full_name} work for?",
    "Who is {full_name}'s employer?",
    "At which company does {full_name} hold a position?",
    "Where does {full_name} apply {possessive_pronoun} professional skills?",
    "What's the name of the company that employs {full_name}?",
    "Which firm is {full_name} associated with professionally?",
    "Where does {full_name} earn {possessive_pronoun} living?",
    "Can you tell me where {full_name} is employed?",
    "What business entity does {full_name} work under?",
    "Which organization benefits from {full_name}'s professional services?",
    "Where does {full_name} contribute {possessive_pronoun} expertise?",
    "What's the name of {full_name}'s current workplace?",
    "In which company does {full_name} pursue {possessive_pronoun} career?",
    "Who pays {full_name}'s salary?",
    "Can you identify {full_name}'s professional affiliation?",
]

company_city_question_templates = [
    "In which city does {full_name} work?",
    "Where is {full_name}'s workplace located?",
    "What city is {full_name} employed in?",
    "Can you name the city where {full_name} works?",
    "Where does {full_name} pursue {possessive_pronoun} career?",
    "In what urban area is {full_name}'s job based?",
    "Which city hosts {full_name}'s place of employment?",
    "Where is {full_name}'s professional base?",
    "What's the location of {full_name}'s workplace?",
    "In which city does {full_name} carry out {possessive_pronoun} professional duties?",
    "Where is {full_name} professionally active?",
    "Can you tell me the city of {full_name}'s employment?",
    "What urban center is home to {full_name}'s job?",
    "In which metropolitan area does {full_name} work?",
    "Where does {full_name} contribute to the local economy?",
    "What city forms the backdrop of {full_name}'s work life?",
    "In which city does {full_name} practice {possessive_pronoun} profession?",
    "Where is {full_name}'s company located?",
    "Can you specify the city where {full_name} is professionally engaged?",
    "What's the urban setting for {full_name}'s career?",
]

# Helper function to filter templates ending with a specific key
def _filter_templates(templates, key):
    return [t for t in templates if t.endswith(f"{{{key}}}." )]

# --- Accuracy Evaluation Templates (Ending with the attribute key) ---

birth_date_accuracy_templates = _filter_templates(birth_date_templates, "birth_date")
birth_city_accuracy_templates = _filter_templates(birth_city_templates, "birth_city")
university_accuracy_templates = _filter_templates(university_templates, "university")
major_accuracy_templates = _filter_templates(major_templates, "major")
employer_accuracy_templates = _filter_templates(employer_templates, "employer")
company_city_accuracy_templates = _filter_templates(company_city_templates, "company_city")

accuracy_template_map = {
    "birth_date": birth_date_accuracy_templates,
    "birth_city": birth_city_accuracy_templates,
    "university": university_accuracy_templates,
    "major": major_accuracy_templates,
    "employer": employer_accuracy_templates,
    "company_city": company_city_accuracy_templates,
}

# Function to get a random accuracy template for a given key
def get_accuracy_template(key: str):
    """Returns a random template suitable for accuracy evaluation for the given key."""
    templates = accuracy_template_map.get(key)
    if not templates:
        raise ValueError(f"No accuracy templates found for key: {key}")
    return random.choice(templates)
