#!/bin/bash

MODEL_BASE="/data/temp_log14/xs_pretrain_small_14/state_step"
JSON_BASE="hallucinate_small/pretrain_perturbed14/"
JSON_SUFFIX="_people_14.json"

LOG_DIR="logs_$(date +'%Y%m%d_%H%M%S')"
mkdir -p "$LOG_DIR"

counter=1

generate_commands() {
    local sample_type=$1
    local steps=(196216)

    # local steps=(4000 49000 72000 99000 142000 149991)

    for step in "${steps[@]}"; do
        formatted_step=$(printf "%06d" $step)
        model_path="${MODEL_BASE}${formatted_step}.pt"
        json_path="${JSON_BASE}${sample_type}${JSON_SUFFIX}"
        log_file="${LOG_DIR}/log${counter}.txt"
        python ABtest_from_pretrain_profile.py -m ${model_path} -f ${json_path} > ${log_file} 2>&1
        ((counter++))
    done
}

echo "# Upsample commands"
generate_commands "upsample"

echo "# Downsample commands"
generate_commands "downsample"