#!/bin/bash

MODEL_BASE="/data/temp_log17/xs_pretrain_small_17/state_step"
JSON_BASE="hallucinate_small/pretrain_perturbed10/"
JSON_SUFFIX="_people_10.json"
NF_JSON="hallucinate_small/pretrain_perturbed17/people_17.json"
SFT_FILE="hallucinate_small/SFT17.txt"

LOG_DIR="logs_$(date +'%Y%m%d_%H%M%S')"
mkdir -p "$LOG_DIR"

model_path="${MODEL_BASE}002000.pt"
json_path="${JSON_BASE}upsample${JSON_SUFFIX}"
log_file="${LOG_DIR}/log.txt"

python test_from_pretrain_and_QA.py \
    -m "${model_path}" \
    -f "${json_path}" \
    -nf "${NF_JSON}" \
    -s "${SFT_FILE}" > "${log_file}" 2>&1

echo "Upsample command executed, output logged to ${log_file}"