#!/bin/bash

# Check if folder parameter is provided
if [ -z "$1" ]; then
  echo "Usage: $0 <folder>"
  exit 1
fi

FOLDER=$1
LOG_FILE="log.txt"
# Loop through all .pt files in the folder
for MODEL_PATH in "$FOLDER"/*.pt; do
  if [ -f "$MODEL_PATH" ]; then
    echo "Running OOD inference for model: $MODEL_PATH" | tee -a "$LOG_FILE"
    python inference_SFT.py --model_path "$MODEL_PATH" --input_path bioS_single/SFT_test.txt --output_path "${MODEL_PATH}_inference_ood.json" --first_n 200 | tee -a "$LOG_FILE"
    echo "Running in-distribution inference for model: $MODEL_PATH" | tee -a "$LOG_FILE"
    python inference_SFT.py --model_path "$MODEL_PATH" --input_path bioS_single/SFT.txt --output_path "${MODEL_PATH}_inference_ind.json" --first_n 200 | tee -a "$LOG_FILE"
    if [[ "$MODEL_PATH" == *"addition"* ]]; then
      echo "Running addition inference for model: $MODEL_PATH" | tee -a "$LOG_FILE"
      python inference_SFT.py --model_path "$MODEL_PATH" --input_path bioS_single/SFT_additional.txt --output_path "${MODEL_PATH}_inference_addition.json" --first_n 200 | tee -a "$LOG_FILE"
    fi
  fi
done
