# setting: power, balanced, unbalanced
# checkpoint: state_step000050.pt state_step000100.pt state_step000200.pt state_step000400.pt state_step00800.pt state_step001600.pt state_step003200.pt state_step005450.pt

# Default to actual run mode
# DRY_RUN=${DRY_RUN:-false}
DRY_RUN=false
path=$1
for setting in sample; do
    checkpoints=()
    for i in $(seq -f "%06g" 100 100 5500); do
        checkpoints+=("state_step${i}.pt")
    done

    # Process checkpoints in batches of 8 using available GPUs
    for ((i = 0; i < ${#checkpoints[@]}; i += 8)); do
        for j in {0..7}; do
            if [ $((i + j)) -lt ${#checkpoints[@]} ]; then
                if [ "$DRY_RUN" = true ]; then
                    echo "Would run: CUDA_VISIBLE_DEVICES=$j python evaluation.py --setting $setting --checkpoint ${checkpoints[$((i + j))]} --path $path"
                else
                    echo "Running: CUDA_VISIBLE_DEVICES=$j python evaluation.py --setting $setting --checkpoint ${checkpoints[$((i + j))]} --path $path"
                    CUDA_VISIBLE_DEVICES=$j python evaluation.py --setting $setting --checkpoint ${checkpoints[$((i + j))]} --path $path &
                fi
            fi
        done
        if [ "$DRY_RUN" = false ]; then
            wait
        else
            echo "Would wait"
        fi
    done
done
