# Pool-Based Active Learning Benchmark

We reproduce and re-benchmark the previous work: [#SV74 A Comparative Survey: Benchmarking for Pool-based Active Learning](https://ijcai-21.org/program-survey/)

*Update on 04/17*, we notice that *Zhan et al.* released the source code: <https://github.com/SineZHAN/ComparativeSurveyIJCAI2021PoolBasedAL>

## Quick start

**Call for Contribution and Future Work**

We call for the community to further provide more experimental results to this benchmark.
We provide below suggested future work:

1. Tasks and domains
    - multi-class classifications
    - regression problems
    - image classifications
    - object detection
    - natural language processing
2. Evaluation metrics
    - Deficiency score, Start Quality, and Average End Quality

### How to start?

1. Provide new datasets: we support LIBSVM dataset format.
    - Update `data/get_data.sh` to download more tabular data.
2. Provide new query strategy: we support libact, Google, and ALiPy modules.
    - Update `src/config.py` to import new query strategies.
3. Provide new experimental settings: we provide common settings as arguments.
    - Update `src/main.py` to adjust the settings such as the size of a test set, size of an initial labeled pool, query-oriented model, task-oriented model, etc.

```shell
cd data; bash get_data.sh  # download datasets
cd ..;
cd src; python main.py  # run experiments, you will see two CSV files. *-aubc.csv* and *-detail.csv*
python main.py -h  # call helper functions
```

## Requriements

- Ubuntu >= 20.04.3 LTS (focal)
- Python >= 3.8, for [ntucllab/libact](https://github.com/ntucllab/libact)

## Installation

Note. We only verify the installation steps on Ubuntu. Please raise the issue if you have any problem.

0. (optional) `apt install vim git python3 python3-venv build-essential gfortran libatlas-base-dev liblapacke-dev python3-dev -y`
1. `python3 -m venv act-env; source act-env/bin/activate`
2. `pip install -r requirements.txt`, we only support Ubuntu >= 20.04 and MacOS >= 13.0
6. `cd data; bash get_data_zhan21.sh; cd ..`
7. `cd src; python main.py -h`

**Warning!** If you use Python == 3.11

3\. `pip install -r requirements-3.11.txt`

6\. `cd libact-dev; LIBACT_BUILD_VARIANCE_REDUCTION=0 LIBACT_BUILD_HINTSVM=0 python setup.py build; LIBACT_BUILD_VARIANCE_REDUCTION=0 LIBACT_BUILD_HINTSVM=0  python setup.py install; cd ..; cp -r libact-dev/libact libact-dev/libact_dev`

You CANNOT obtain the results of Hinted Support Vector Machine (HintSVM) and Variability Reduction (VR) for the benchmark.

**Warning!** If your env cannot support liblapack

6. `cd libact-dev; LIBACT_BUILD_VARIANCE_REDUCTION=0 python setup.py build; LIBACT_BUILD_VARIANCE_REDUCTION=0 python setup.py install; cd ..; cp -r libact-dev/libact libact-dev/libact_dev`

You CANNOT obtain the results of Variability Reduction (VR) for the benchmark.

**Warning!** If your OS is macOS.

0\. `brew install cmake`

3\. `pip install -r requirements-macos.txt`

## Step-by-Step tutorial

Bellowing examples demonstrate how to use the benchmark for quick use, evaluating existing AL query strategies on your own datasets, and adding new AL query strategies for evaluating.

### Running AL experiments

This is an example of running compatible uncertainty sampling (US-C) on *Haberman* dataset based on RBF kernel SVM.

`python main.py --tool google --qs_name margin-zhan --hs_name google-zhan --gs_name zhan --seed 0 --n_trials 1 --data_set haberman;`

### Evaluation (WIP)

TODO. Split evaluation part from *main.py*

### Customize datasets (WIP)

### Customize query strategies (WIP)

## Reproduce all experiments for [#SV74 A Comparative Survey: Benchmarking for Pool-based Active Learning](https://ijcai-21.org/program-survey/)

### List of current settings

1. Settings of initial pools
    - Size of test set (`--tst_size=0.4`): $40\%$
    - Size of initial labeled pool (`--init_lbl_size=20`): $20$.
    - Construction of initial labeled pool (`--exp_name="RS"`): random split training set (not test set) into labeled and unlabeled pools.
    - Data preprocessing (`--exp_names="scale"`): apply `scaler = StandardScaler()` to dataset.
2. List of query strategies, their corresponding query-oriented model, and task-oriented model.
	- task-oriented model $\mathcal{G}$: SVM(RBF)

| QS       | query-oriented model                                                      |
|----------|---------------------------------------------------------------------------|
| US-C     | SVM(RBF)                                                                  |
| US-NC    | LR(C=0.1)                                                                 |
| QBC      | LR(C=1); SVM(Linear, probability=True); SVM(RBF, probability=True); LDA   |
| VR       | LR(C=1)                                                                   |
| EER      | SVM(RBF, probability=True)                                                |
| Core-Set | N/A                                                                       |
| Graph    | N/A                                                                       |
| Hier     | N/A                                                                       |
| HintSVM  | SVM(RBF)                                                                  |
| QUIRE    | SVM(RBF)                                                                  |
| DWUS     | SVM(RBF)                                                                  |
| InfoDiv  | SVM(RBF)                                                                  |
| MCM      | SVM(RBF)                                                                  |
| BMDR     | SVM(RBF)                                                                  |
| SPAL     | SVM(RBF)                                                                  |
| ALBL     | # Combination of QSs with same query-oriented model: US-C; US-NC; HintSVM |
| LAL      | SVM(RBF)                                                                  |

### Steps of reproducing

1. Reproduce all results in Zhan et al. (Warning! It will take you a very long time!)

```shell
cd src;
bash run-reproduce-google.sh  # run all google datasets
bash run-reproduce-libact.sh  # run all libact datasets
bash run-reproduce-libact.sh  # run all libact datasets
bash run-reproduce-bso.sh  # run all bso datasets
bash run-reproduce-infeasible.sh  # run all infeasible time datasets, only for time test
```
**Note**
- `N_JOBS`: number of workers. Users can accelerate according to their number of CPUs.
  **WARNING!** Some methods could be slower because of insufficient resources.

2. Reproduce all figures and tables in this work.

- Reproduce results in Zhan et al.

```shell
cd results/rbfsvm-exps_rebenchmarkZhan2021;
gdown 15Bq8ju5E3zFMZyoPqblI3iVTrFVbKpNN -O aubc-rbfsvm.zip; unzip aubc-rbfsvm.zip;
gdown 14mT6Ypa6TtXLuxDB0yCwlYxa2xCEPEQH -O detail-rbfsvm.zip; unzip detail-rbfsvm.zip;
python analysis.py;
```

- Reproduce results of the model compatibility

```shell
cd results/rbfsvm-exps_rebenchmarkZhan2021/differentModels;
gdown 1YsIuKAfu1xd5YSpYwfHQ7_0XEWNKDwB_ -O aubc_detail-model_compatibility.zip; unzip aubc_detail-model_compatibility.zip;
python analysis.py;
```

- Reproduce results in main article (XGBoost)

```shell
cd results/xgboost-exps;
gdown 1UspE_PT5-8kwutZOFAVtz-wDR5JxzLR7 -O aubc-xgboost.zip; unzip aubc-xgboost.zip;
gdown 1iz60wLZiBvsTyvc9WdY9q3C2MA0A_KGC -O detail-xgboost.zip; unzip detail-xgboost.zip;
python analysis.py;
python parsing_detail_from_detail.py;
python analysis_budget.py
python analysis_ckptAccs.py
python analysis_dur.py
```

- Reproduce results in Appendix D (Random Forest)

```shell
cd results/rf-exps;
gdown 1R3aHEbnJ-vjqfuX76seEeSWSWC6E64nR -O aubc-rf.zip; unzip aubc-rf.zip;
gdown 142W07hmvedjODCD_yd6VZqRtvBfawjOx -O detail-rf.zip; unzip detail-rf.zip;
python analysis.py;
python parsing_detail_from_detail.py;
python analysis_budget.py
python analysis_ckptAccs.py
python analysis_dur.py
```