# Benchmark of pool-based active learning

Mean(Standard Deviation) of Uniform (Random Sampling), 17 query strategies and Beam-Search Oracle (BSO) on 26 binary datasets.

| data         | uniform        | us               | qbc              | hintsvm         | quire           | albl            | dwus            | vr               | kcenter          | margin           | graph           | hier             | infodiv        | mcm              | eer             | bmdr            | spal            | lal              | bso             |
|:-------------|:---------------|:-----------------|:-----------------|:----------------|:----------------|:----------------|:----------------|:-----------------|:-----------------|:-----------------|:----------------|:-----------------|:---------------|:-----------------|:----------------|:----------------|:----------------|:-----------------|:----------------|
| appendicitis | 0.8395(0.0363) | 0.8449³(0.0322)  | 0.8441(0.0334)   | 0.839(0.0322)   | 0.8399(0.0344)  | 0.8449(0.0316²) | 0.8421(0.0324)  | 0.8395(0.0363)   | 0.8398(0.0327)   | 0.8454²(0.0333)  | 0.8419(0.0317³) | 0.8414(0.0295¹)  | 0.8454(0.0333) | 0.8457¹(0.0334)  | 0.8426(0.0364)  | 0.8418(0.033)   | 0.8415(0.032)   | 0.8433(0.0339)   | 0.8837(0.0295)  |
| sonar        | 0.7463(0.0379) | 0.7622(0.0329)   | 0.7655³(0.0309²) | 0.7357(0.0366)  | 0.7475(0.0365)  | 0.76(0.0332)    | 0.7405(0.0388)  | 0.7463(0.0379)   | 0.742(0.0353)    | 0.7762¹(0.0313³) | 0.7538(0.0352)  | 0.7511(0.0375)   | 0.7762(0.0313) | 0.773²(0.0305¹)  | 0.7544(0.0341)  | 0.7571(0.037)   | 0.7458(0.032)   | 0.7651(0.0321)   | 0.884(0.0284)   |
| parkinsons   | 0.8305(0.0368) | 0.8511³(0.0321²) | 0.8449(0.0348)   | 0.8178(0.0389)  | 0.8305(0.0364)  | 0.8461(0.0333³) | 0.8274(0.0392)  | 0.8305(0.0368)   | 0.8356(0.0346)   | 0.8531¹(0.0343)  | 0.8291(0.0345)  | 0.8357(0.0347)   | 0.8531(0.0343) | 0.8527²(0.0341)  | 0.8451(0.0334)  | 0.8369(0.0357)  | 0.8385(0.0355)  | 0.8463(0.0313¹)  | 0.8828(0.0319)  |
| ex8b         | 0.8853(0.028)  | 0.8938(0.025)    | 0.8939(0.0255)   | 0.8699(0.0328)  | 0.8785(0.0333)  | 0.8873(0.0259)  | 0.884(0.0262)   | 0.8853(0.028)    | 0.8916(0.0257)   | 0.8981¹(0.0245²) | 0.8856(0.0262)  | 0.888(0.0257)    | 0.8981(0.0245) | 0.8978²(0.0242¹) | 0.8936(0.0258)  | 0.8885(0.0273)  | 0.8821(0.0293)  | 0.8943³(0.0245³) | 0.9376(0.0182)  |
| heart        | 0.8051(0.0279) | 0.812(0.0266)    | 0.813³(0.0265)   | 0.8039(0.028)   | 0.8103(0.0268)  | 0.8118(0.0274)  | 0.8057(0.0288)  | 0.8051(0.0279)   | 0.8105(0.026²)   | 0.8157¹(0.0262³) | 0.8054(0.0274)  | 0.8075(0.0276)   | 0.8157(0.0262) | 0.8154²(0.0269)  | 0.8085(0.0253¹) | 0.8065(0.0267)  | 0.8097(0.0268)  | 0.8124(0.0267)   | 0.893(0.0247)   |
| haberman     | 0.7308(0.027)  | 0.7301(0.0286)   | 0.7304(0.0274³)  | 0.7259(0.0282)  | 0.7244(0.029)   | 0.7298(0.0274)  | 0.7312²(0.0292) | 0.7308(0.0268¹)  | 0.7267(0.028)    | 0.7295(0.0287)   | 0.7301(0.0276)  | 0.73(0.028)      | 0.7295(0.0287) | 0.7291(0.0282)   | 0.7311³(0.0284) | 0.7319¹(0.0293) | 0.7302(0.0277)  | 0.7308(0.0268²)  | 0.7896(0.0305)  |
| ionosphere   | 0.918(0.0178)  | 0.9197(0.0179)   | 0.9278³(0.0163)  | 0.8964(0.0244)  | 0.9015(0.0211)  | 0.9206(0.0155³) | 0.8793(0.0486)  | 0.918(0.0178)    | 0.9134(0.0166)   | 0.93¹(0.0154²)   | 0.9162(0.0189)  | 0.9204(0.0175)   | 0.93(0.0154)   | 0.9296²(0.0159)  | 0.9249(0.0159)  | 0.8934(0.032)   | 0.9232(0.0158)  | 0.9265(0.0144¹)  | 0.9545(0.0142)  |
| clean1       | 0.8183(0.0194) | 0.8329(0.0195²)  | 0.8341³(0.02³)   | 0.7695(0.0325)  | 0.818(0.0218)   | 0.8266(0.0224)  | 0.8183(0.0194¹) | too long (time)  | 0.7897(0.0249)   | 0.8425¹(0.0214)  | 0.8105(0.0241)  | 0.8183(0.0235)   | 0.8425(0.0214) | 0.8412²(0.0218)  | 0.8216(0.0219)  | 0.8156(0.0219)  | 0.8(0.0244)     | 0.8335(0.0211)   | 0.9219(0.0169)  |
| breast       | 0.9616(0.009)  | 0.9624(0.0092)   | 0.963³(0.009)    | 0.9623(0.009)   | 0.9623(0.009)   | 0.9624(0.009)   | 0.9604(0.009)   | 0.9582(0.0099)   | 0.9626(0.009)    | 0.9632¹(0.0091)  | 0.9614(0.0087¹) | 0.9615(0.0089³)  | 0.9632(0.0091) | 0.9631²(0.009)   | 0.9629(0.009)   | 0.9616(0.0087²) | 0.9629(0.0089)  | 0.9585(0.0098)   | 0.976(0.0067)   |
| wdbc         | 0.9539(0.013)  | 0.9597(0.0111)   | 0.9626³(0.0107)  | 0.9558(0.0111)  | 0.9583(0.0103²) | 0.9612(0.0102¹) | 0.9504(0.0157)  | 0.9539(0.013)    | 0.9586(0.0105)   | 0.9652¹(0.0103³) | 0.954(0.0123)   | 0.9565(0.0107)   | 0.9652(0.0103) | 0.965²(0.0104)   | 0.9622(0.0107)  | 0.9512(0.0127)  | 0.9572(0.0113)  | 0.9613(0.0106)   | 0.9841(0.0065)  |
| australian   | 0.8483(0.0158) | 0.8459(0.0159)   | 0.8494(0.0159)   | 0.8444(0.017)   | 0.8476(0.0158)  | 0.8486(0.0166)  | 0.8473(0.0152¹) | 0.8483(0.0158)   | 0.8478(0.0158)   | 0.8504¹(0.0157³) | 0.8469(0.0171)  | 0.8487(0.0159)   | 0.8504(0.0157) | 0.8504²(0.0162)  | 0.8472(0.0161)  | 0.8473(0.0158)  | 0.8504³(0.0158) | 0.8483(0.0155²)  | 0.9046(0.0148)  |
| diabetes     | 0.7424(0.0152) | 0.7432(0.0147)   | 0.7472³(0.0141²) | 0.7456(0.0152)  | 0.747(0.0141³)  | 0.7443(0.0152)  | 0.7227(0.0188)  | 0.7424(0.0152)   | 0.7491¹(0.0138¹) | 0.7479²(0.0153)  | 0.7424(0.0154)  | 0.7434(0.0154)   | 0.7479(0.0153) | 0.7471(0.0147)   | 0.7457(0.0152)  | 0.7423(0.0154)  | 0.7465(0.0144)  | 0.7462(0.0147)   | 0.8257(0.017)   |
| mammographic | 0.813(0.0198)  | 0.8167(0.0206)   | 0.8169³(0.0206)  | 0.8105(0.0208)  | 0.8158(0.0192²) | 0.8163(0.0189¹) | 0.7999(0.0214)  | 0.8128(0.0193³)  | 0.8162(0.0193)   | 0.8177²(0.0195)  | 0.8125(0.0205)  | 0.8146(0.02)     | 0.8177(0.0195) | 0.8178¹(0.0194)  | 0.8165(0.0199)  | 0.8135(0.0201)  | 0.8139(0.0204)  | 0.8151(0.0204)   | 0.8503(0.0197)  |
| ex8a         | 0.8539(0.0217) | 0.8273(0.022)    | 0.8601(0.0161¹)  | 0.8136(0.0327)  | 0.8072(0.0379)  | 0.8407(0.0196)  | 0.7911(0.0346)  | 0.8539(0.0217)   | 0.854(0.0201)    | 0.8788¹(0.0176³) | 0.8504(0.02)    | 0.8603³(0.0215)  | 0.8788(0.0176) | 0.8766²(0.0172²) | 0.8504(0.0216)  | 0.8531(0.0199)  | 0.8552(0.0204)  | 0.8342(0.0189)   | 0.8828(0.0203)  |
| tic          | 0.8718(0.0153) | 0.8718(0.0154)   | 0.8719(0.0157)   | 0.8719(0.0153)  | 0.8699(0.0148²) | 0.8718(0.0152)  | 0.871(0.0146¹)  | 0.8718(0.0153)   | 0.8716(0.0149³)  | 0.872¹(0.0158)   | 0.872²(0.0155)  | 0.8719(0.0153)   | 0.872(0.0158)  | 0.872³(0.0159)   | 0.8719(0.0157)  | 0.8719(0.0152)  | 0.8712(0.015)   | 0.872(0.0159)    | 0.9077(0.0227)  |
| german       | 0.734(0.0173)  | 0.7388(0.0149³)  | 0.7395³(0.0144¹) | 0.7305(0.0167)  | 0.7357(0.0156)  | 0.7366(0.0144²) | 0.7268(0.016)   | 0.734(0.0173)    | 0.7365(0.0152)   | 0.7417¹(0.0154)  | 0.7353(0.0154)  | 0.7349(0.0163)   | 0.7417(0.0154) | 0.741²(0.0156)   | 0.738(0.0158)   | 0.7347(0.0161)  | 0.7364(0.0152)  | 0.7392(0.0153)   | 0.8208(0.0201)  |
| splice       | 0.8075(0.0161) | 0.8158³(0.0138)  | 0.8154(0.0135)   | 0.7783(0.0253)  | 0.8044(0.0159)  | 0.8112(0.0144)  | 0.7578(0.0266)  | 0.8075(0.0161)   | 0.7518(0.0276)   | 0.8229²(0.013²)  | 0.7818(0.0133³) | 0.8075(0.0142)   | 0.8229(0.013)  | 0.8234¹(0.0127¹) | 0.8075(0.0143)  | 0.7985(0.0156)  | 0.8007(0.0149)  | 0.806(0.0153)    | 0.9102(0.0118)  |
| gcloudb      | 0.8952(0.0117) | 0.8853(0.0225)   | 0.8967(0.0106²)  | 0.8748(0.018)   | 0.8776(0.0193)  | 0.8968³(0.0108) | 0.8856(0.0188)  | 0.8952(0.0117)   | 0.892(0.0118)    | 0.8981¹(0.0109)  | 0.8937(0.0114)  | 0.895(0.0115)    | 0.8981(0.0109) | 0.8979²(0.0107³) | 0.8944(0.0114)  | 0.8952(0.0111)  | 0.893(0.0112)   | 0.8946(0.0105¹)  | 0.9091(0.0109)  |
| gcloudub     | 0.9437(0.0096) | 0.949(0.0089)    | 0.9529³(0.0082²) | 0.8955(0.0244)  | 0.9329(0.0121)  | 0.9382(0.0119)  | 0.9364(0.0104)  | 0.9437(0.0096)   | 0.8929(0.0181)   | 0.956¹(0.0082³)  | 0.9434(0.0093)  | 0.9475(0.0086)   | 0.956(0.0082)  | 0.9553²(0.0081¹) | 0.9388(0.0103)  | 0.9384(0.0108)  | 0.9075(0.0357)  | 0.9473(0.0084)   | 0.9683(0.0078)  |
| checkerboard | 0.9781(0.0059) | 0.9134(0.0258)   | 0.9702(0.0123)   | 0.9242(0.0152)  | 0.9437(0.0189)  | 0.9679(0.0082)  | 0.9045(0.0268)  | 0.9781(0.0059)   | 0.9874¹(0.0031¹) | 0.9847²(0.0062)  | 0.9737(0.006)   | 0.9785(0.0069)   | 0.9847(0.0062) | 0.9847³(0.006)   | 0.984(0.0051³)  | 0.9832(0.0046²) | error           | 0.9641(0.0104)   | 0.9972(0.0036)  |
| spambase     | 0.9103(0.0057) | 0.901(0.0044)    | 0.919³(0.0042²)  | 0.8985(0.008)   | error           | 0.9162(0.0033¹) | 0.9103(0.0057)  | too long (time)  | 0.9052(0.0073)   | 0.9205¹(0.0043³) | 0.9073(0.0051)  | 0.9122(0.0047)   | 0.9205(0.0043) | 0.92²(0.0043)    | too long (time) | too long (time) | too long (time) | 0.9062(0.0053)   | too long (time) |
| banana       | 0.8926(0.0038) | 0.805(0.0306)    | 0.8908(0.0059)   | 0.851(0.0173)   | 0.8299(0.0126)  | 0.8851(0.0066)  | 0.8164(0.0122)  | 0.8926³(0.0037²) | 0.893¹(0.0048)   | 0.8787(0.0219)   | 0.8848(0.0039)  | 0.8929²(0.0035¹) | 0.8787(0.0219) | 0.8754(0.0202)   | too long (time) | too long (time) | too long (time) | 0.8923(0.0037³)  | too long (time) |
| phoneme      | 0.8254(0.0101) | 0.8211(0.0078)   | 0.8318³(0.0063)  | 0.8083(0.0101)  | 0.8183(0.0068)  | 0.8247(0.0071)  | 0.8137(0.008)   | too long (time)  | 0.824(0.0059²)   | 0.8355²(0.0063)  | 0.8209(0.0079)  | 0.83(0.0062³)    | 0.8355(0.0063) | 0.8359¹(0.0055¹) | too long (time) | too long (time) | too long (time) | 0.8242(0.0121)   | too long (time) |
| ringnorm     | 0.9776(0.0021) | 0.9767(0.0028)   | 0.9771(0.0026³)  | 0.9715(0.0053)  | too long (time) | 0.9769(0.0023¹) | 0.9346(0.0101)  | too long (time)  | 0.9477(0.019)    | 0.9786¹(0.0026)  | 0.9711(0.0023²) | 0.9766(0.0026)   | 0.9786(0.0026) | 0.9782²(0.0026)  | too long (time) | too long (time) | too long (time) | 0.978³(0.0026)   | too long (time) |
| twonorm      | 0.9753(0.0019) | 0.9755(0.0018)   | 0.976(0.0017)    | 0.9736(0.0013¹) | too long (time) | 0.9752(0.0017)  | 0.9731(0.002)   | too long (time)  | 0.9755(0.0017)   | 0.9764¹(0.0017)  | 0.9754(0.002)   | 0.9752(0.0016²)  | 0.9764(0.0017) | 0.9763²(0.0017)  | too long (time) | too long (time) | too long (time) | 0.9761³(0.0016³) | too long (time) |
| phishing     | 0.9382(0.0048) | 0.9391(0.004¹)   | 0.9441³(0.0042²) | 0.9296(0.0052)  | too long (time) | 0.942(0.0043³)  | 0.8923(0.0105)  | too long (time)  | 0.9406(0.0043)   | 0.946¹(0.0049)   | 0.9327(0.0053)  | 0.938(0.0049)    | 0.946(0.0049)  | 0.9449²(0.0047)  | too long (time) | too long (time) | too long (time) | 0.9429(0.0045)   | too long (time) |# Usefulness of query strategies

Mean difference of the query strategy from Uniform
`*' and `**' mean reject pair $t$-test with significance level $0.05$ and $0.01$ respectively.

- The `⚠️' means not enough number of repeated experiments.
- The `🤔' means hard to differentiate the performance of different query strategies.

|         | appendicitis   | sonar    | parkinsons   | ex8b       | heart    |   haberman | ionosphere🤔   | clean1🤔   | breast   | wdbc🤔     | australian   | diabetes   | mammographic   | ex8a🤔   |     tic | german   | splice🤔   | gcloudb🤔   | gcloudub🤔   | checkerboard🤔   | spambase   | banana🤔   | phoneme   | ringnorm🤔   | twonorm   | phishing   |
|:--------|:---------------|:---------|:-------------|:-----------|:---------|-----------:|:---------------|:-----------|:---------|:-----------|:-------------|:-----------|:---------------|:---------|--------:|:---------|:-----------|:------------|:-------------|:-----------------|:-----------|:-----------|:----------|:-------------|:----------|:-----------|
| us      | 0.0054**       | 0.0159** | 0.0207**     | 0.0085**   | 0.007**  |    -0.0008 | 0.0017         | 0.0146**⚠️ | 0.0008** | 0.0058**   | -0.0025      | 0.0008     | 0.0037**       | -0.0266  |  0      | 0.0048** | 0.0083**   | -0.0099⚠️   | 0.0053**     | -0.0647          | -0.0093    | -0.0875    | -0.0043   | -0.0009      | 0.0002    | 0.0009     |
| qbc     | 0.0046*        | 0.0192** | 0.0144**     | 0.0085**⚠️ | 0.008**  |    -0.0004 | 0.0098**       | 0.0157**⚠️ | 0.0015** | 0.0088**   | 0.0011       | 0.0048**   | 0.0039**       | 0.0062** |  0.0001 | 0.0055** | 0.0078**   | 0.0015**    | 0.0092**     | -0.0079          | 0.0087**   | -0.0017    | 0.0064**  | -0.0005      | 0.0007**  | 0.0059**   |
| hintsvm | -0.0005        | -0.0106  | -0.0127      | -0.0154    | -0.0012  |    -0.0049 | -0.0216        | -0.0489    | 0.0007** | 0.002**    | -0.0039      | 0.0032**   | -0.0025        | -0.0403  |  0.0001 | -0.0035  | -0.0292    | -0.0204⚠️   | -0.0482      | -0.0539⚠️        | -0.0118    | -0.0415    | -0.0171   | -0.0061      | -0.0017   | -0.0086    |
| quire   | 0.0004         | 0.0011   | -0.0         | -0.0068    | 0.0053** |    -0.0065 | -0.0165        | -0.0003    | 0.0007** | 0.0044**   | -0.0008      | 0.0046**   | 0.0028**       | -0.0467  | -0.0019 | 0.0017*  | -0.0031    | -0.0176⚠️   | -0.0108      | -0.0344⚠️        |            | -0.0627    | -0.0071   |              |           |            |
| albl    | 0.0054**       | 0.0137** | 0.0156**     | 0.0019     | 0.0068** |    -0.001  | 0.0026*        | 0.0083**⚠️ | 0.0009** | 0.0073**   | 0.0003       | 0.0019*    | 0.0033**       | -0.0132  |  0      | 0.0026** | 0.0036**   | 0.0016**    | -0.0055      | -0.0102          | 0.0059**   | -0.0074    | -0.0007   | -0.0007      | -0.0001   | 0.0038**   |
| dwus    | 0.0026         | -0.0058  | -0.003       | -0.0013    | 0.0006   |     0.0004 | -0.0387⚠️      | 0.0        | -0.0012  | -0.0035⚠️  | -0.001       | -0.0197    | -0.0131        | -0.0627  | -0.0008 | -0.0072  | -0.0498    | -0.0096⚠️   | -0.0073      | -0.0736⚠️        | -0.0       | -0.0761    | -0.0117   | -0.043       | -0.0022   | -0.046     |
| vr      | 0.0            | 0.0      | 0.0          | 0.0        | 0.0      |    -0.0001 | 0.0            |            | -0.0034  | 0.0⚠️      | 0.0          | 0.0        | -0.0002        | 0.0      |  0      | 0.0      | 0.0        | 0.0         | 0.0          | 0.0              |            |            |           |              |           |            |
| kcenter | 0.0003         | -0.0044  | 0.0051**     | 0.0063**   | 0.0054** |    -0.0041 | -0.0046        | -0.0286    | 0.001**  | 0.0047**⚠️ | -0.0006      | 0.0067**   | 0.0032**       | 0.0001   | -0.0002 | 0.0025** | -0.0557    | -0.0032     | -0.0508      | 0.0093**         | -0.005     | 0.0005     | -0.0014   | -0.0299      | 0.0002    | 0.0024**   |
| margin  | 0.0058**       | 0.0299** | 0.0226**     | 0.0127**   | 0.0107** |    -0.0014 | 0.012**        | 0.0242**   | 0.0016** | 0.0113**   | 0.0021**     | 0.0054**   | 0.0047**       | 0.0249** |  0.0001 | 0.0077** | 0.0154**   | 0.0029**    | 0.0123**     | 0.0066**         | 0.0102**   | -0.0139⚠️  | 0.0101**  | 0.001**      | 0.0011**  | 0.0078**   |
| graph   | 0.0024         | 0.0075** | -0.0013      | 0.0002     | 0.0004   |    -0.0008 | -0.0018        | -0.0078    | -0.0002  | 0.0001     | -0.0014      | -0.0       | -0.0005        | -0.0035  |  0.0002 | 0.0013   | -0.0257    | -0.0015     | -0.0003      | -0.0044          | -0.003     | -0.0078    | -0.0045   | -0.0065      | 0.0001    | -0.0055    |
| hier    | 0.0019         | 0.0048*  | 0.0052**     | 0.0027*    | 0.0025   |    -0.0008 | 0.0024*        | -0.0       | -0.0     | 0.0026**   | 0.0004       | 0.001      | 0.0016*        | 0.0064** |  0.0001 | 0.0009   | -0.0       | -0.0002     | 0.0038**     | 0.0004⚠️         | 0.0019*    | 0.0003     | 0.0046*   | -0.001       | -0.0001   | -0.0002    |
| infodiv | 0.0058**       | 0.0299** | 0.0226**     | 0.0127**   | 0.0107** |    -0.0014 | 0.012**        | 0.0242**   | 0.0016** | 0.0113**   | 0.0021**     | 0.0054**   | 0.0047**       | 0.0249** |  0.0001 | 0.0077** | 0.0154**   | 0.0029**    | 0.0123**     | 0.0066**         | 0.0102**   | -0.0139⚠️  | 0.0101**  | 0.001**      | 0.0011**  | 0.0078**   |
| mcm     | 0.0062**       | 0.0266** | 0.0222**     | 0.0124**   | 0.0104** |    -0.0017 | 0.0116**       | 0.0229**   | 0.0016** | 0.0111**   | 0.0021**     | 0.0047**   | 0.0048**       | 0.0227** |  0.0002 | 0.007**  | 0.0159**   | 0.0027**    | 0.0116**     | 0.0066**⚠️       | 0.0097**   | -0.0171⚠️  | 0.0105**  | 0.0006*      | 0.001**   | 0.0067**   |
| eer     | 0.0031⚠️       | 0.0081** | 0.0147**     | 0.0082**   | 0.0035*  |     0.0003 | 0.0069**       | 0.0033*⚠️  | 0.0013** | 0.0084**   | -0.0012      | 0.0032**   | 0.0035**       | -0.0035  |  0.0001 | 0.004**  | -0.0       | -0.0008     | -0.0049      | 0.0059**⚠️       |            |            |           |              |           |            |
| bmdr    | 0.0023         | 0.0107** | 0.0065**     | 0.0032*    | 0.0014   |     0.0011 | -0.0246        | -0.0027    | 0.0001   | -0.0026    | -0.001       | -0.0002    | 0.0005         | -0.0008  |  0.0001 | 0.0007   | -0.009     | -0.0⚠️      | -0.0053      | 0.0051**         |            |            |           |              |           |            |
| spal    | 0.002          | -0.0006  | 0.0081**     | -0.0032    | 0.0046** |    -0.0006 | 0.0052**       | -0.0184    | 0.0014** | 0.0033**⚠️ | 0.0021**     | 0.004**    | 0.0009         | 0.0013   | -0.0006 | 0.0024** | -0.0069    | -0.0022     | -0.0362      |                  |            |            |           |              |           |            |
| lal     | 0.0038*        | 0.0187** | 0.0158**     | 0.009**    | 0.0073** |    -0.0001 | 0.0085**       | 0.0152**   | -0.003   | 0.0074**   | -0.0         | 0.0037**   | 0.0021*        | -0.0197  |  0.0002 | 0.0052** | -0.0016    | -0.0006     | 0.0036**     | -0.0139⚠️        | -0.0041    | -0.0002    | -0.0012   | 0.0004       | 0.0008**  | 0.0047**   |