# Copyright (c) Meta Platforms, Inc. and affiliates.
# All rights reserved.
#
# This source code is licensed under the license found in the
# LICENSE file in the root directory of this source tree.
"""
Models for EnCodec, AudioGen, MusicGen, as well as the generic LMModel.
"""
# flake8: noqa
from . import builders, loaders
from .audiogen import AudioGen
from .encodec import (DAC, CompressionModel, EncodecModel,
                      HFEncodecCompressionModel, HFEncodecModel,
                      MReQ)
from .halle import Halle
from .halle2 import Halle2
from .lm import LMModel
from .lm_magnet import MagnetLMModel
from .magnet import MAGNeT
from .multibanddiffusion import MultiBandDiffusion
from .musicgen import MusicGen
from .unet import DiffusionUnet
from .valle import Valle
