# Copyright (c) Meta Platforms, Inc. and affiliates.
# All rights reserved.
#
# This source code is licensed under the license found in the
# LICENSE file in the root directory of this source tree.
"""
Solvers. A Solver is a training recipe, combining the dataloaders, models,
optimizer, losses etc into a single convenient object.
"""

# flake8: noqa
from .audiogen import AudioGenSolver
from .base import StandardSolver
from .builders import get_solver
from .compression import CompressionSolver
from .mreq import MReQSolver
from .diffusion import DiffusionSolver
from .musicgen import MusicGenSolver
from .valle_ar import ValleARSolver
from .valle_nar import ValleNARSolver
from .halle_ar import HalleARSolver
from .halle_nar import HalleNARSolver
from .halle2_nar import Halle2NARSolver
