#!/usr/bin/env bash
# Set bash to 'debug' mode, it will exit on :
# -e 'error', -u 'undefined variable', -o ... 'error in pipeline', -x 'print commands',
set -e
set -u
set -o pipefail

SOLVER=your_solver_name  # ex: compression/encodec_valle_24khz
ARGS=""

ENV_SOURCE=your_conda_path  #ex: ~/anaconda3/etc/profile.d/conda.sh
ENV_NAME=audiocraft
SRC_PATH=/path/to/this/repo
LOG_PATH=/path/to/log
TEAM_NAME=your_team_name
WANDB_API_KEY=your_wandb_api_key

source ${ENV_SOURCE}
conda activate ${ENV_NAME}
cd ${SRC_PATH}
export PYTHONPATH=${SRC_PATH}
export WANDB_API_KEY=${WANDB_API_KEY}
export AUDIOCRAFT_TEAM=${TEAM_NAME}
dora run -d solver=${SOLVER} ${ARGS}
