import argparse

from audiocraft.utils import export

parser = argparse.ArgumentParser(description='Export LM and Encodec state dict')
parser.add_argument('--path_lm', type=str, default=None, help='Path to the LM model')
parser.add_argument('--path_lm_output', type=str, default='output/state_dict.bin', help='Path to the output LM state dict')
parser.add_argument('--path_lm2', type=str, default=None, help='Path to the LM model')
parser.add_argument('--path_lm2_output', type=str, default='output/state_dict.bin', help='Path to the output LM state dict')
parser.add_argument('--path_encodec', type=str, default=None, help='Path to the Encodec model')
parser.add_argument('--path_encodec_output', type=str, default='output/compression_state_dict.bin', help='Path to the output Encodec state dict')
args = parser.parse_args()

if args.path_lm is not None:
    export.export_lm(args.path_lm, args.path_lm_output)
if args.path_lm2 is not None:
    export.export_lm(args.path_lm2, args.path_lm2_output)
if args.path_encodec is not None:
    export.export_encodec(args.path_encodec, args.path_encodec_output)
