from setuptools import setup
import os
import sys

_here = os.path.abspath(os.path.dirname(__file__))

if sys.version_info[0] < 3:
    with open(os.path.join(_here, "README.md")) as f:
        long_description = f.read()
else:
    with open(os.path.join(_here, "README.md"), encoding="utf-8") as f:
        long_description = f.read()

setup(
    name="DCS",
    version="0.0",
    description=("Deep Curvature Suite"),
    long_description=long_description,
    author="",
    author_email="",
    url="",
    license="MPL-2.0",
    packages=["DCS"],
    install_requires=[
        "tqdm==4.26.0",
        "numpy>=1.14.3",
        "torchvision==0.2.0",
        "gpytorch==0.3.6",
        "tabulate>=0.8.2",
        "scipy>=1.1.0",
        "setuptools>=39.1.0",
        "matplotlib>=2.2.2",
        "torch==1.0.0",
        "Pillow>=5.4.1",
        "scikit_learn>=0.20.2",
        "seaborn",
    ],
    include_package_data=True,
    classifiers=[
        "Development Status :: 0",
        "Intended Audience :: Science/Research",
        "Programming Language :: Python :: 3.6",
    ],
)