from ucimlrepo import fetch_ucirepo 
  
# fetch dataset 
df = fetch_ucirepo(id=189) 
  
# data (as pandas dataframes) 
X = df.data.features 
y = df.data.targets["total_UPDRS"]
  
# standarize X
from sklearn.preprocessing import StandardScaler
scaler = StandardScaler().fit(X)
X_std = scaler.transform(X)

# append y to the last column of X
import numpy as np
data_proc = np.hstack((X_std, np.array(y).reshape(-1,1)))

# sample 500 rows from array data_proc
data_sub = data_proc[np.random.choice(data_proc.shape[0], 500, replace=False), :]

# write data_sub to csv file with header just x1, x2 ...
import pandas as pd
data_sub_df = pd.DataFrame(data_sub, columns=["x"+str(i) for i in range(1, 21)]) 
# save data_sub_df to csv file
data_sub_df.to_csv("dat.csv", index=False)


