function error_checking_fwd(o::HamFlow, a::HF_params, n_ref::Int; nsample::Int=100, refresh::Function=ref_coord, inv_ref::Function=inv_ref_coord)
    ```
    T = mixflow
    compute "||(z, ρ, u) - T^{-1}∘T(z, ρ, u)||"
    ```
    ft = eltype(a.μ)
    E = zeros(ft, nsample)
    prog_bar = ProgressMeter.Progress(nsample, dt=0.5, barglyphs=ProgressMeter.BarGlyphs("[=> ]"), barlen=50, color=:yellow)
    @threads for i in 1:nsample
        # take init sample
        ρ0, u0 = ft.(o.ρ_sampler(o.d)), rand(ft)
        z0 = a.D .* ft.(o.q_sampler(o.d)) .+ a.μ
        # fwd and bwd flow
        z1, ρ1, u1 = flow_fwd(o, a.leapfrog_stepsize, refresh, z0, ρ0, u0, n_ref)
        z, ρ, u = flow_bwd(o, a.leapfrog_stepsize, inv_ref, z1, ρ1, u1, n_ref)
        # compute err
        error = sum(abs2, z .- z0) + sum(abs2, ρ .- ρ0) + sum(abs2, u - u0)
        E[i] = sqrt(error)
        ProgressMeter.next!(prog_bar)
    end
    return E
end

function flow_bwd_err(z, ρ, u, o::HamFlow, a::HF_params, n_ref::Int; refresh::Function=ref_coord, inv_ref::Function=inv_ref_coord)
    z1, ρ1, u1 = flow_bwd(o, a.leapfrog_stepsize, inv_ref, z, ρ, u, n_ref)
    z0, ρ0, u0 = flow_fwd(o, a.leapfrog_stepsize, refresh, z1, ρ1, u1, n_ref)
    # compute err
    error = sum(abs2, z .- z0) + sum(abs2, ρ .- ρ0) + sum(abs2, u - u0)
    return error
end

function flow_fwd_err(z, ρ, u, o::HamFlow, a::HF_params, n_ref::Int; refresh::Function=ref_coord, inv_ref::Function=inv_ref_coord)
    z1, ρ1, u1 = flow_fwd(o, a.leapfrog_stepsize, refresh, z, ρ, u, n_ref)
    z0, ρ0, u0 = flow_bwd(o, a.leapfrog_stepsize, inv_ref, z1, ρ1, u1, n_ref)
    # compute err
    error = sum(abs2, z .- z0) + sum(abs2, ρ .- ρ0) + sum(abs2, u - u0)
    return error
end

function error_checking_bwd(o::HamFlow, a::HF_params, n_ref::Int; nsample::Int=100, refresh::Function=ref_coord, inv_ref::Function=inv_ref_coord)
    ```
    T = mixflow
    compute "||(z, ρ, u) - T∘T^{-1}(z, ρ, u)||"
    ```
    ft = eltype(a.μ)
    E = zeros(ft, nsample)
    prog_bar = ProgressMeter.Progress(nsample, dt=0.5, barglyphs=ProgressMeter.BarGlyphs("[=> ]"), barlen=50, color=:yellow)
    @threads for i in 1:nsample
        # take init sample
        ρ0, u0 = ft.(o.ρ_sampler(o.d)), rand(ft)
        z0 = a.D .* ft.(o.q_sampler(o.d)) .+ a.μ
        # fwd and bwd flow
        z1, ρ1, u1 = flow_bwd(o, a.leapfrog_stepsize, inv_ref, z0, ρ0, u0, n_ref)
        z, ρ, u = flow_fwd(o, a.leapfrog_stepsize, refresh, z1, ρ1, u1, n_ref)
        # compute err
        error = sum(abs2, z .- z0) + sum(abs2, ρ .- ρ0) + sum(abs2, u - u0)
        E[i] = sqrt(error)
        ProgressMeter.next!(prog_bar)
    end
    return E
end