include("model.jl")
include("../../inference/MixFlow/MixFlow.jl")
include("../common/plotting.jl")
include("../common/result.jl")
using LogExpFunctions, ProgressMeter

n_lfrg = 40
o = MixFlow.HamFlow(
    d,
    n_lfrg,
    logp,
    ∇logp,
    randn,
    logq,
    randn,
    MixFlow.lpdf_normal,
    MixFlow.∇lpdf_normal,
    MixFlow.cdf_normal,
    MixFlow.invcdf_normal,
    MixFlow.pdf_normal,
)

MF = JLD.load("result/mfvi.jld")
μ, D = MF["μ"], MF["D"]
ϵ = 1e-2
a = MixFlow.HF_params(ϵ * ones(d), μ, D)

setprecision(BigFloat, 2048)
ft = BigFloat
a_big = MixFlow.HF_params(ft(ϵ) * ones(d), ft.(μ), ft.(D))
ϵ = a.leapfrog_stepsize
