using LinearAlgebra
using BlockBandedMatrices
# using PDMats



function construct_shadow_matrix(M)
    Diag = [m*m'+I for m in M]
    offD = [-m for m in M[2:end]]
    L = BlockTridiagonal(offD, Diag, offD)
    return Symmetric(Matrix(L), :L)
end

function shadowing_window(L, δ)
    σ = sqrt(eigmin(L))
    return 2*δ/σ
end


# symmetrize matrix
# A = randn(10000, 10000)
# A = Symmetric(A + A')
# # this is O(N^3), havn't implemented the fast methods
# @time F = LinearAlgebra.hessenberg!(A).H
# L = eigvals(F)
# @time eigvals(A)
# @time eigmin(A)
# As = eigen(A + A')
# F = LinearAlgebra.hessenberg!(A).H

# ..  SymTridiagonal(d, du)

# Construct a real symmetric tridiagonal matrix from the diagonal and upper diagonal, respectively. The result is of type ``SymTridiagonal`` and provides efficient specialized eigensolvers, but may be converted into a regular matrix with :func:`full`.


# use \texttt{LinearAlgebra.hessenberg!} to
# % reduce to symtridiag, then use \texttt{LinearAlgebra.eigvals}


# create a block tridiagonal matrix
# using BlockBandedMatrices
# A = BlockTridiagonal(fill([1 2; 3 4 ],3), fill([3 4; 4 3],4), fill([4 5; 6 7],3))
# S = Symmetric(Matrix(A), :L)
# F = Hessenberg(Matrix(Symmetric(A, :L)))
# eigvals(sparse(B))