classdef LeastSquareCost < matlab.mixin.SetGet
    %LOGREGCOST Summary of this class goes here
    %   Logistic cost function class
    %   logistic cost function=1/n*\sum_{i=1}^{n}log(1+exp(-y_iw^Tx_i))
    %   Properties:
    %       w = [tilde_w, b]
    %       
    properties
        X            % data matrix(mxn): # of samples(m), # of features(n).
        num_features % number of features
        num_samples  % number of samples
        y            % labels of samples
    end
    
    methods
        
        %construction method
        function obj=LeastSquareCost(X,y)
            obj.num_samples=length(y);
            obj.num_features=size(X,2);  % add one dummy feature for bias
            obj.X=X;
            obj.y=y;
        end
        
        %return the logistic cost value 
        function f=func(obj, w, indexes)
            f = 1 / (length(indexes) * 2.0) * norm(obj.X(indexes, :) * w - obj.y(indexes))^2;
            % f = 1/length(indexes) * sum(log(1+obj.expterm));
            % f=1/obj.num_samples*sum(log(1+obj.expterm));
        end
        
        % calculate the gradient of logistic cost function
        function g = grad(obj, w, indexes)
            g = 1 / length(indexes) * ( obj.X(indexes, :)' * obj.X(indexes, :) * w - obj.X(indexes, :)' * obj.y(indexes) );
            % g = -1/length(indexes)*((obj.sigmoid.*obj.y(indexes))'*obj.X(indexes, :))';
        end        
                
        function obj=setX(obj,X)
            set(obj,'X',X);
        end
        
        function obj=setY(obj,y)
            set(obj,'y',y);
        end    
        
        function obj=setNumberfeatures(obj,num_features)
            set(obj,'num_features',num_features);
        end 
        
        function obj=setNumbersamples(obj,num_samples)
            set(obj,'num_samples',num_samples);
        end       
        
    end
    
end

