function [info] = runprob(pname)

%Load synthesize data
probLoad = sprintf(['synthesize_data/',pname,'.mat']);

load(probLoad);

%Load parameter settings
parms = hspg_fp_mixed_l1l2_spec;

% Choose weighting parameter, set objective function.
lambda = 100/size(X,1); % Need to look into this.

% Get the lossfunction by X,y.
funObj = lossfunction.LeastSquareCost(X,y);

% Solve the problem.
info = hspg_fp_mixed_l1l2_solver(pname,funObj,lambda,parms);

% if synthesize data
info.real_idx_gs = idx_zero_groups;
info.pred_idx_gs = info.idx_zero_groups;
info.iou_gs = utils.get_iou(info.real_idx_gs, info.pred_idx_gs);
info = rmfield(info, 'idx_zero_groups');

return
