## Intrusction of Reproducing Numerical Experiments in *HSPG*
-----

### 1.Convex Experiments:

In **`src/convex/logistic_regression`** directory, we provide the source code of the tested optimizers in the submitted paper, i.e., **Prox-SG**, **RDA**, **Prox-SVRG**,  and **HSPG**, on solving the convex mixed l1/l2-regularized logistic regression problem. A **`dataset`** folder is offerred with several test datasets. Besides, a **`run_all_prob.m`** Matlab script is given to reproduce the numerical results via one button. 

The below is a brief description of each sub-directory under **`src/convex`**:

- **`dataset`**: stores three demo datasets shown in the paper, i.e., *australian*, *diabetes_scaled*, *w8a*.

- **`proxsg`**: Matlab source code for Proximal Stochastic Gradient method.

- **`rda`**: Matlab source code for Regularized Dual Averaging method.

- **`proxsvrg`**: Matlab source code for Proximal Stochastic Variance-Reduced Gradient method.

- **`hspg`**: Matlab source code for Half-Space Proximal Stochastic Gradient method.



To reproduce the numerical results in Section 4.1, follow the below steps: 

####  Step 1. Download datasets (Optional):

Besides the three given demo datasets, you may want to access all the eight datasets presented in Section 4.1 of the submitted paper.  

- Because of the size limitation, we describe how to generate corresponding .mat files as follows if needed:
	
	- Download the corresponding raw .txt datasets from Libsvm repository.
		
	- Clone the Libsvm github repository:
		<https://github.com/cjlin1/libsvm>
		
	- Jump to **`libsvm/matlab`** directory and follow the instruction to compile matlab Libsvm.

	- Make use of **`libsvmread`** function to load the raw .txt datasets.

	- Save them into .mat files by the **`save`** function in Matlab, and move .mat files to **`src/convex/datasets`** directory. 
	

####  Step 2. Run numerical experiments:

In Matlab shell, 

- Jump to **`src/convex`** directory

- Run **`run_all_prob.m`** Matlab script via 
	
	```
	run_all_prob
	```
  
  to excute all test experiments.


#### Step 3. Check Numerical Experiments:

The numerical results from Step 2 will be automatically saved into 
**`src/convex/logistic_regression/numerical_results.csv`**.

