function [info] = runprob(pname)
%====================================================================
% Purpose : Solve a test problem using the solver fPlusL1.
%====================================================================
%
% Input:
%    pname: name of the problem being solving. 
%====================================================================
dir = '../datasets/libsvm/';

%Load the problem
probLoad = sprintf([dir,pname,'.mat']);
load(probLoad);


%Load parameter settings
parms = proxsvrg_fp_mixed_l1l2_spec;
parms.batch_size = min([256, floor(0.01 * size(X, 1))]);

norm_square_samples = vecnorm(X') .^ 2;
L = max(norm_square_samples) / 4.0;
parms.alpha = 1.0 / L; 

% Choose weighting parameter, set objective function.
lambda = 100/size(X,1); % Need to look into this.

% Get the lossfunction by X,y.
funObj = lossfunction.LogRegCost(X,y);

% Solve the problem.
info = proxsvrg_fp_mixed_l1l2_solver(pname,funObj,lambda,parms);

return
