function [info] = runprob(pname, type)
%====================================================================
% Purpose : Solve a test problem using the solver RDA-gl.
%====================================================================
%
% Input:
%    pname: name of the problem being solving. 
%====================================================================
dir = '../datasets/libsvm/';

%Load the problem
probLoad = sprintf([dir,pname,'.mat']);
load(probLoad);

%Load parameter settings
parms = rdagl_fp_mixed_l1l2_spec;
parms.batch_size = min([256, floor(0.01 * size(X, 1))]);

% Choose weighting parameter, set objective function.
lambda = 100/size(X,1); % Need to look into this.

% Get the lossfunction by X,y.
funObj = lossfunction.LogRegCost(X,y);

% Solve the problem.
info = rdagl_fp_mixed_l1l2_solver(pname,funObj,lambda,parms);

return
