%====================================================================
% Purpose : Run methods on all the test problems.
%====================================================================
clc
clear

data_dir = 'datasets/libsvm/';

datasets = dir(sprintf([data_dir, '*.mat']));

methods = {
           'hspg',...
           'proxsg',...
           'proxsvrg',...
           'rda',...
           };  

fid = fopen('numerical_results.csv', 'a');
draw_header(methods, fid)

% comment out the next line to run all the datasets

for dataset = datasets' 
    [~, pname, ~] = fileparts(dataset.name);
    fprintf(fid, '%23s,', pname);
    disp(['========== Dataset ' pname ' =========='])
    for method = methods
        disp(['---- Running method: ' method{:} ' ----'])
        
        forward_path = method{:};
        back_path = '..';
        cd(forward_path) 
        
        eval(['info.' pname '.' method{:} '= runprob(pname);']);
        print_info(info, pname, method, fid);
        
        cd(back_path)
    end
    fprintf(fid, '\n');
    disp('')
end

fclose(fid);
draw_header(methods, 1)
draw_report(datasets, methods, info)


%%
%=========================================================================
%                         HELPER FUNCTIONS
%=========================================================================

function draw_header(methods, fid)
    fprintf(fid, '\n\n');
    fprintf(fid, '                                                Summary\n');
    fprintf(fid, ',');
    for method = methods
        fprintf(fid, '%s,,,,,,,', method{:});
    end
    fprintf(fid, '\n');
    fprintf(fid, 'problem,F_val,f_val,Omega_val,density,sparsity,group_sparsity,runtime,F_val,f_val,Omega_val,density,sparsity,group_sparsity,runtime,F_val,f_val,Omega_val,density,sparsity,group_sparsity,runtime,F_val,f_val,Omega_val,density,sparsity,group_sparsity,runtime\n');
end

function draw_report(datasets, methods, info)
    for dataset = datasets' 
        [~, pname, ~] = fileparts(dataset.name);
        fprintf('%-33s,', pname)
        for method = methods
            print_info(info, pname, method, 1);
        end
        fprintf('\n')
    end
end

function print_info(info, pname, method, fid)
    eval(['Fval=info.' pname '.' method{:} '.Fval;'])
    eval(['fval=info.' pname '.' method{:} '.fval;'])
    eval(['Omegaval=info.' pname '.' method{:} '.Omegaval;'])
    eval(['density=info.' pname '.' method{:} '.density;'])
    eval(['sparsity=info.' pname '.' method{:} '.sparsity;'])
    eval(['group_sparsity=info.' pname '.' method{:} '.group_sparsity;'])
    eval(['runtime=info.' pname '.' method{:} '.runtime;'])
    eval('fprintf(fid, ''%8.4f,%8.4f,%8.4f,%.8f,%.8f,%.8f,%.3f,'', Fval, fval, Omegaval, density, sparsity, group_sparsity, runtime);')
end
