# MetaAdapter: Leveraging Meta-Learning for Expandable  Representation in Few-Shot Class Incremental Learning (MetaAdapter)

The code repository for "MetaAdapter: Leveraging Meta-Learning for Expandable  Representation in Few-Shot Class Incremental Learning"



## MetaAdapter: Leveraging Meta-Learning for Expandable  Representation in Few-Shot Class Incremental Learning

Few-shot class incremental learning (FSCIL) aims to enable  models to learn new tasks from few labeled samples while retaining knowledge of previously ones. This  scenario typically involves an offline base session with sufficient data for pre-training, followed by online incremental sessions where new classes are learned from limited samples. Existing methods either rely on a frozen feature extractor or meta-testing simulation to address overfitting issues in online sessions. However, they primarily learn feature representations using only the base session data, which significantly compromises the model's plasticity in feature representations. To enhance plasticity and reduce overfitting, we propose the MetaAdapter framework, which makes use of meta-learning for expandable representation. During the base session, we expand the network with pre-trained weights by inserting parallel adapters and employ meta-learning to encode generalizable knowledge into these modules. Then, the backbone is further trained on abundant data from the base classes to acquire fundamental classification ability.  In each online session, the adapters are first initialized with parameters from meta-training, and subsequently tuned to adapt to the new classes. Leveraging  meta-learning to produce initial adapters, MetaAdapter enables the feature extractor to effectively adapt to few-shot new classes, thus improving the generalization  of the model.  Experimental results on the mini-ImageNet, CUB200, and CIFAR100 datasets demonstrate that our proposed framework achieves the state-of-the-art performance.


## Results
![results](imgs/results.jpg)

Please refer to our paper for detailed values.

## Prerequisites

The following packages are required to run the scripts:

- [PyTorch-2.0.1 and torchvision](https://pytorch.org)

- tqdm

## Dataset
We provide the source code on three benchmark datasets, i.e., CIFAR100, CUB200 and mini-ImageNet. Please follow the guidelines in [CEC](https://github.com/icoz69/CEC-CVPR2021) to prepare them.


## Code Structures and details
There are three parts in the code.
 - `models`: It contains the backbone network and training protocols for the experiment.
 - `data`: Images and splits for the data sets.
 - `dataloader`: Dataloader of different datasets.

## Training scripts

Please see `scripts` folder.
