import torch
from torch.utils.data import DataLoader
from torchvision import transforms
from torchvision import datasets  # 放置了许多常用数据集,包括手写数字识别
import torch.nn.functional as F
import numpy as np
from torch.utils.data import DataLoader,Dataset,TensorDataset
# from tqdm import tqdm
import os, sys
from torch.nn import init

import os, sys
import time
import pickle
import warnings

warnings.filterwarnings("ignore")
import numpy as np
import torch
import torch.nn as nn
from torch.nn import init
import torch.optim as optim
import torch.nn.functional as F
import matplotlib
import math
matplotlib.use('Agg')
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D
from matplotlib.ticker import LinearLocator, FormatStrFormatter
from matplotlib import cm
import platform
import shutil


os.environ['CUDA_VISIBLE_DEVICES'] = '0,1,2,3,4,5,6,7'
Leftp = 0.18
Bottomp = 0.18
Widthp = 0.88 - Leftp
Heightp = 0.9 - Bottomp
pos = [Leftp, Bottomp, Widthp, Heightp]


def mkdir(fn):  # Create a directory
    if not os.path.isdir(fn):
        os.mkdir(fn)


def save_fig(pltm, fntmp, fp=0, ax=0, isax=0, iseps=0, isShowPic=0):  # Save the figure
    if isax == 1:
        pltm.rc('xtick', labelsize=18)
        pltm.rc('ytick', labelsize=10)
        ax.set_position(pos, which='both')
    fnm = '%s.png' % (fntmp)
    pltm.savefig(fnm)
    if iseps:
        fnm = '%s.eps' % (fntmp)
        pltm.savefig(fnm, format='eps', dpi=600)
    if fp != 0:
        fp.savefig("%s.pdf" % (fntmp), bbox_inches='tight')
    if isShowPic == 1:
        pltm.show()
    elif isShowPic == -1:
        return
    else:
        pltm.close()




class Net(torch.nn.Module):
    def __init__(self,m,t):
        super(Net, self).__init__()
        self.l1 = torch.nn.Linear(4, m)
        init.normal_(self.l1.weight, 0, 1/m**(t))
        init.normal_(self.l1.bias, 0, 1/m**(t))
        self.l2 = torch.nn.Linear(m, 3,bias=False)
        init.normal_(self.l2.weight, 0, 1/m**(t))
        # init.normal_(self.l2.bias, 0, 1/m**(t))
        # self.l3 = torch.nn.Linear(m, m)
        # init.normal_(self.l3.weight, 0, 1/m**(t))
        # init.normal_(self.l3.bias, 0, 1/m**(t))
        # self.l4 = torch.nn.Linear(m, 10,bias=False)
        # init.normal_(self.l4.weight, 0, 1/m**(t))
    def forward(self, x):
        # x = x.view(-1, 784)
        x = F.sigmoid(self.l1(x))
        # x = F.relu(self.l2(x))
        # x = F.relu(self.l3(x))
        # x = F.relu(self.l3(x))
        # x = F.relu(self.l4(x))
        return self.l2(x)

m=5
t=3
device = torch.device("cuda:%s" % (1) if torch.cuda.is_available() else "cpu")
model = Net(m,t).to(device)
# PATH='/home/dir/data/saddle_points/test88/100/3.0/12441'
load_dir='/home/dir/data/loss_landscape/test100/5/6.0/13677/model_fin.ckpt'
Path1=torch.load(load_dir,map_location='cuda:1')
model.load_state_dict(Path1)
print(model.l1.weight.shape)
print(model.l1.bias.shape)
weight_new=torch.cat((model.l1.weight,model.l1.bias.unsqueeze(1)),1)
print(weight_new.shape)
tensor_all=[]
for i in range(m):
    tensor_ori=weight_new[i,:]
    # print(tensor_ori.shape)#[785]
    tensor_ori=tensor_ori/torch.norm(tensor_ori)
    tensor_all.append(tensor_ori)
    # print(torch.norm(tensor_ori))#1

ori=np.zeros((m,m))


for i in range(m):
    print(i)
    for j in range(m):
        if j>i-1:
            # print((tensor_all[i]*tensor_all[j]).shape)
            ori[i,j]=sum(tensor_all[i]*tensor_all[j]).item()

np.savetxt('/home/dir/data/loss_landscape/test100/5/6.0/13677/ori1.txt',ori)




