import torch
from torch.utils.data import DataLoader
from torchvision import transforms
from torchvision import datasets  # 放置了许多常用数据集,包括手写数字识别
import torch.nn.functional as F
import numpy as np
from torch.utils.data import DataLoader,Dataset,TensorDataset
# from tqdm import tqdm
import os, sys
from torch.nn import init

import os, sys
import time
import pickle
import warnings

warnings.filterwarnings("ignore")
import numpy as np
import torch
import torch.nn as nn
from torch.nn import init
import torch.optim as optim
import torch.nn.functional as F
import matplotlib
import math
matplotlib.use('Agg')
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D
from matplotlib.ticker import LinearLocator, FormatStrFormatter
from matplotlib import cm
import platform
import shutil


os.environ['CUDA_VISIBLE_DEVICES'] = '0,1,2,3,4,5,6,7'
Leftp = 0.18
Bottomp = 0.18
Widthp = 0.88 - Leftp
Heightp = 0.9 - Bottomp
pos = [Leftp, Bottomp, Widthp, Heightp]


def mkdir(fn):  # Create a directory
    if not os.path.isdir(fn):
        os.mkdir(fn)


def save_fig(pltm, fntmp, fp=1, ax=0, isax=0, iseps=0, isShowPic=0):  # Save the figure
    if isax == 1:
        pltm.rc('xtick', labelsize=18)
        pltm.rc('ytick', labelsize=10)
        ax.set_position(pos, which='both')
    fnm = '%s.png' % (fntmp)
    pltm.savefig(fnm)
    if iseps:
        fnm = '%s.eps' % (fntmp)
        pltm.savefig(fnm, format='eps', dpi=600)
    if fp != 0:
        pltm.savefig("%s.pdf" % (fntmp), bbox_inches='tight')
    if isShowPic == 1:
        pltm.show()
    elif isShowPic == -1:
        return
    else:
        pltm.close()


def one_hot(x, class_count):
	return torch.eye(class_count)[x,:]

lenarg = np.shape(sys.argv)[
    0]  # Sys.argv[ ]其实就是一个列表，里边的项为用户输入的参数，关键就是要明白这参数是从程序外部输入的，而非代码本身的什么地方，要想看到它的效果就应该将程序保存了，从外部来运行程序并给出参数。
if lenarg > 1:
    ilen = 1
    while ilen < lenarg:
        if sys.argv[ilen] == '-m':
            m = np.int32(sys.argv[ilen + 1])
        if sys.argv[ilen] == '-g':
            d = np.int32(sys.argv[ilen + 1])
        if sys.argv[ilen]=='-t':
            t=np.float32(sys.argv[ilen+1])
        # if sys.argv[ilen]=='-s':
        #     R['train_size']=np.int32(sys.argv[ilen+1])
        # if sys.argv[ilen]=='-lr':
        #     R['learning_rate']=np.float32(sys.argv[ilen+1])
        # if sys.argv[ilen]=='-dir':
        #     sBaseDir=sys.argv[ilen+1]
        ilen = ilen + 2

transform = transforms.Compose([
    transforms.ToTensor(),  # 转张量，将值缩放到[0,1]之间
    transforms.Normalize((0.1307,),(0.3081,))  # 归一化，第一个为均值，第二个为方差
])


train_dataset = datasets.MNIST(root= "/home/zhangzhongwang/data/saddle_points/MNIST/mnist",
                              train=True,  # 下载训练集
                              transform=transform,  # 转张量，将值缩放到[0,1]之间.也可以写成transform = transforms.ToTensor()
                              download=True
                              )

test_dataset = datasets.MNIST(root= "/home/zhangzhongwang/data/saddle_points/MNIST/mnist",
                              train=False,  # 下载训练集
                              transform=transform,  # 转张量，将值缩放到[0,1]之间
                           download=True)
batch_size=60000
train_dataset0=[]
train_target0=[]

#
for i in range(60000):
    if len(train_dataset0)<1000:
        train_dataset0.append(train_dataset[i][0].unsqueeze(0))
        train_target0.append(train_dataset[i][1])
    else:
        break

train_dataset_new=torch.cat(train_dataset0,0)
train_label_new= torch.from_numpy(np.array(train_target0))


train_dataset2 = TensorDataset(train_dataset_new, train_label_new)
train_loader = DataLoader(train_dataset2, batch_size=batch_size, shuffle=True,num_workers=8)

test_loader = DataLoader(dataset=test_dataset,
                         batch_size=batch_size,
                         shuffle=False,num_workers=8)
train_loader=list(train_loader)
test_loader=list(test_loader)

class Net(torch.nn.Module):
    def __init__(self,m,t):
        super(Net, self).__init__()
        self.l1 = torch.nn.Linear(784, m)
        init.normal_(self.l1.weight, 0, 1/m**(t))
        init.normal_(self.l1.bias, 0, 1/m**(t))
        self.l2 = torch.nn.Linear(m, 10,bias=False)
        init.normal_(self.l2.weight, 0, 1/m**(t))
        # init.normal_(self.l2.bias, 0, 1/m**(t))
        # self.l3 = torch.nn.Linear(m, m)
        # init.normal_(self.l3.weight, 0, 1/m**(t))
        # init.normal_(self.l3.bias, 0, 1/m**(t))
        # self.l4 = torch.nn.Linear(m, 10,bias=False)
        # init.normal_(self.l4.weight, 0, 1/m**(t))
    def forward(self, x):
        x = x.view(-1, 784)
        x = F.relu(self.l1(x))
        # x = F.relu(self.l2(x))
        # x = F.relu(self.l3(x))
        # x = F.relu(self.l3(x))
        # x = F.relu(self.l4(x))
        return self.l2(x)

device = torch.device("cuda:%s" % (d) if torch.cuda.is_available() else "cpu")
model = Net(m,t).to(device)
m_reduced=44
PATH='/home/zhangzhongwang/data/loss_landscape/test97/400/6.0/32_1.0/137159'
load_dir='%s/model_13000.ckpt'%(PATH)
Path1=torch.load(load_dir,map_location='cuda:1')
model.load_state_dict(Path1)

model_reduced = Net(m_reduced,t).to(device)

PATH='/home/zhangzhongwang/data/loss_landscape/test97_narrow/44/3.0/1000_0.001/44273'
load_dir='%s/model_fin.ckpt'%(PATH)
Path1=torch.load(load_dir,map_location='cuda:1')
model_reduced.load_state_dict(Path1)

for batch_idx, dataall in enumerate(test_loader,1):
    data, target=dataall
    data, target = data.to(device), target.to(device)
    inputs = data

    outputs = model(inputs)
    # print(outputs)
    outputs=torch.nn.functional.softmax(outputs)

    print(outputs.shape)

    outputs_reduced = model_reduced(inputs)
    # print(outputs)
    outputs_reduced=torch.nn.functional.softmax(outputs_reduced)

    print(outputs_reduced.shape)

outputs=torch.reshape(outputs,(-1,1))
outputs_reduced=torch.reshape(outputs_reduced,(-1,1))

np.savetxt('%s/outputs_train.txt'%(PATH),outputs.detach().cpu().numpy())
np.savetxt('%s/outputs_reduced_train.txt'%(PATH),outputs_reduced.detach().cpu().numpy())

y1=outputs_reduced.detach().cpu().numpy()
y2=outputs.detach().cpu().numpy()
# plt.figure()
# plt.plot(y1,y2,"*")
# plt.show()
y1r = y1.reshape([-1,10])
y2r = y2.reshape([-1,10])
pred1 = np.argmax(y1r,axis = 1)
pred2 = np.argmax(y2r,axis = 1)
np.sum(pred1==pred2)/10000
plt.figure()
plt.hist2d(pred1,pred2,10)
plt.colorbar()
plt.show()
mkdir('%s/pic1'%(PATH))


fig,ax = plt.subplots()
# ax = sns.heatmap(cos_distance_matrix_temp,linewidths = 0,vmin=-1,vmax=1,cmap='YlGnBu_r') # ,xticklabels = np.arange(40),yticklabels = np.arange(40))
# ax.set_xticks(np.arange(40)) #设置x轴刻度
# ax.set_yticks(np.arange(40)) #设置y轴刻度
# ax.xaxis.set_ticks_position('top')
# ax.set_xticklabels(range(40),fontsize=5)
# ax.set_yticklabels(range(40),fontsize=5)
# plt.imshow(cos_distance_matrix_temp,cmap='YlGnBu_r')
plt.hist2d(pred2,pred1,10)
# cb = plt.colorbar(ticks=[-1.0,0.0,1.0])
cb=plt.colorbar()
cb.ax.tick_params(labelsize=24)
# ax.xaxis.set_ticks_position('top')
plt.ylabel('reduced net prediction',fontsize=24)
plt.xlabel('original net prediction',fontsize=24)
# plt.clim(-1, 1)
plt.yticks([0,4,8],size=24)
plt.xticks([0,4,8],size=24)
# plt.colorbar(fig, ) 
# plt.xticks([])  #去掉x轴
# plt.yticks([])  #去掉y轴
# ax.set_title("cos distance: tanh",fontsize=18)
plt.tight_layout()
fntmp = '%s/pic2/75000'%(PATH)
# save_fig(plt, fntmp, ax=ax, isax=1, iseps=0)
plt.savefig("%s.pdf" % (fntmp), bbox_inches='tight')
plt.savefig('%s.png'%(fntmp))
# plt.close()
# plt.clf()


