import json
from tqdm import tqdm

test_path = './test.json'
output_path = './test.jsonl'

# 读取 JSON 文件
with open(test_path, 'r', encoding='utf-8') as file:
    data = json.load(file)

# 写入 JSONL 文件
with open(output_path, mode='w', encoding='utf-8') as json_file:
    for line in tqdm(data, desc='Converting to JSONL'):
        json_file.write(json.dumps(line, ensure_ascii=False) + '\n')
