from .q_learner import QLearner
from .noise_q_learner import QLearner as NoiseQLearner
from .dmd_q_learner import QLearner as DMDQLearner
from .coma_learner import COMALearner
from .actor_critic_learner import ActorCriticLearner
from .qtran_learner import QLearner as Qtranlearner
from .ppo_learner import PPOLearner as PPOLearner
from .dmd_ppo_learner import PPOLearner as DMDPPOLearner

REGISTRY = {}

REGISTRY["q_learner"] = QLearner
REGISTRY["noise_q_learner"] = NoiseQLearner
REGISTRY["dmd_q_learner"] = DMDQLearner
REGISTRY["coma_learner"] = COMALearner
REGISTRY["actor_critic_learner"] = ActorCriticLearner
REGISTRY["qtran_learner"] = Qtranlearner
REGISTRY["ppo_learner"] = PPOLearner
REGISTRY["dmd_ppo_learner"] = DMDPPOLearner
