% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy_results_frm_db.R
\name{accuracy_results_frm_db}
\alias{accuracy_results_frm_db}
\title{Comprehensive results from several accuracy_db files}
\usage{
accuracy_results_frm_db(
  accuracy_db_dir = "accuracy_db",
  cor_types = c("loose_pearson", "cor_pearson", "sharp_pearson", "cor_spearman",
    "cor_kendall", "cor_dhsic", "cor_dcor", "cor_mic", "cor_xicor"),
  scenario_type = c("accuracy_mon", "accuracy_notmon", "accuracy", "Xks"),
  ...
)
}
\arguments{
\item{accuracy_db_dir, }{the way to store the accuracy files}

\item{cor_types, }{correlations}

\item{scenario_type, }{type of scenarios}
}
\value{
a data.frame
}
\description{
Extract and combine data.frames from several several accuracy_db files
}
\details{
\enumerate{
  \item Call accuracy_db() to generate the basic results
  \item Call accuracy_results_frm_db() to generate the accuracy results data.frame
  \item Call accuracy_plot_lite() to draw the figures
}


load_rbind.data.table() all possible accuracy_db() files into a whole
}
