% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_ccc.R
\name{cor_ccc}
\alias{cor_ccc}
\title{Concordance correlation coefficient}
\usage{
cor_ccc(x, y)
}
\arguments{
\item{x, }{numeric vector}

\item{y, }{numeric vector}
}
\value{
correlation coefficients
}
\description{
A wrapper of yardstick::ccc_vec(x, y)
}
\details{
See help file for yardstick::ccc_vec(x, y)


The following three ways can be employed to calculate ccc:  


\enumerate{
  \item DescTools::CCC(x, y)$rho.c$est
  \item epiR::epi.ccc(x, y)$rho.c$est
  \item yardstick::ccc_vec(x, y)
}
 

yardstick::ccc_vec(x, y) is the fastest, but its results are 
a bit different from the former two.
}
\references{
Lin, L. (1989). A concordance correlation coefficient 
to evaluate reproducibility. Biometrics, 45 (1), 255-268.
}
