% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_kendall.R
\name{cor_kendall}
\alias{cor_kendall}
\title{Fast implementations of (robust) correlation estimators}
\usage{
cor_kendall(x, y)
}
\arguments{
\item{x, }{numeric vector}

\item{y, }{numeric vector}
}
\value{
correlation coefficients
}
\description{
Estimate the correlation of two vectors via fast C++ implementations, 
with a focus on robust and nonparametric methods.
}
\details{
See help file for ccaPP::corKendall

Until now (2022-11-14), ccaPP provides the fastest implementation 
of Pearson, Spearman, Kendall, Quadrant than 
stats::cor, wdm::wdm() 
wdm also claims being faster than cor

faster even then pcaPP::cor.fk, which claims to be faster 
than stats::cor(x, y, method = "Kendall")
}
