% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenarios2.R
\name{scenarios2}
\alias{scenarios2}
\title{Get all the scenarios, both monotonic and notmonotonic}
\usage{
scenarios2(
  type = c("all", "accuracy", "accuracy_mon", "accuracy_notmon", "power", "power_mon",
    "power_notmon", "power_distinguish", "extreme_mon_pairs", "Xks"),
  with_expr = TRUE
)
}
\arguments{
\item{type, }{type of scenarios, see the details}

\item{with_expr, }{whether the funs should be attained by the expressions}
}
\value{
numeric vector
}
\description{
Get all the scenarios, both monotonic and notmonotonic
}
\details{
There are 9 types of scenarios:

\itemize{
  \item all, all the scenarios
  \item accuracy, scenarios for accuracy analysis (1~66)
  \item accuracy_mon, monotonic scenarios for accuracy analysis (1~50)
  \item accuracy_notmon, notmonotonic scenarios for accuracy analysis (51~66)
  \item power, scenarios for power analysis (1~107)
  \item power_mon, monotonic scenarios for power analysis (1~50, 67~107)
  \item power_notmon, the same as nonmonotonic scenarios for accuracy analysis (51~66)
  \item power_distinguish, 45 distinguishable scenarios for power analysis
  \item extreme_mon_pairs, 12 normally and extremely monotonic scenarios for power analysis
}


All scenarios are listed in the following table:


\tabular{rlllllll}{
  \strong{index} \tab \strong{funs} \tab \strong{exprs} \tab \strong{monotonic} \tab \strong{extreme_mon} \tab \strong{distinguish_mon} \tab \strong{power} \tab \strong{accuracy} \cr
    1 \tab y <- 2*x+1                                                                                    \tab 'Linear'                          \tab YES \tab NA \tab NA \tab YES \tab YES\cr
    2 \tab y <- x^2                                                                                      \tab 'Quadratic'                       \tab YES \tab NA \tab NA \tab YES \tab YES\cr
    3 \tab y <- sqrt(x)                                                                                  \tab 'Square Root'                     \tab YES \tab NA \tab NA \tab YES \tab YES\cr
    4 \tab y <- x^3                                                                                      \tab 'Cubic'                           \tab YES \tab 1  \tab NA \tab YES \tab YES\cr
    5 \tab y <- 1/x                                                                                      \tab 'Reciprocal'                      \tab YES \tab NA \tab 15 \tab YES \tab YES\cr
    6 \tab y <- exp(x)                                                                                   \tab 'Exponential'                     \tab YES \tab NA \tab NA \tab YES \tab YES\cr
    7 \tab y <- log(x)                                                                                   \tab 'Logarithm'                       \tab YES \tab NA \tab NA \tab YES \tab YES\cr
    8 \tab y <- sin(pi/2*x)                                                                              \tab 'Sine'                            \tab YES \tab NA \tab NA \tab YES \tab YES\cr
    9 \tab y <- cos(pi/2*x)                                                                              \tab 'Cosine'                          \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   10 \tab y <- tan(pi/2*x)                                                                              \tab 'Tangent'                         \tab YES \tab NA \tab 19 \tab YES \tab YES\cr
   11 \tab y <- cot(pi/2*x)                                                                              \tab 'Cotangent'                       \tab YES \tab NA \tab 20 \tab YES \tab YES\cr
   12 \tab y <- asin(x)                                                                                  \tab 'I-Sine'                          \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   13 \tab y <- acos(x)                                                                                  \tab 'I-Cosine'                        \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   14 \tab y <- atan(x)                                                                                  \tab 'I-Tangent'                       \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   15 \tab y <- acot(x)                                                                                  \tab 'I-Cotangent'                     \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   16 \tab y <- sec(pi/2*x)                                                                              \tab 'Secant'                          \tab YES \tab NA \tab 4  \tab YES \tab YES\cr
   17 \tab y <- csc(pi/2*x)                                                                              \tab 'Cosecant'                        \tab YES \tab NA \tab 5  \tab YES \tab YES\cr
   18 \tab y <- sinh(x)                                                                                  \tab 'H-Sine'                          \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   19 \tab y <- cosh(x)                                                                                  \tab 'H-Cosine'                        \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   20 \tab y <- tanh(x)                                                                                  \tab 'H-Tangent'                       \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   21 \tab y <- coth(x)                                                                                  \tab 'H-Cotangent'                     \tab YES \tab NA \tab 21 \tab YES \tab YES\cr
   22 \tab y <- sech(100*x)                                                                              \tab 'H-Secant'                        \tab YES \tab NA \tab 10 \tab YES \tab YES\cr
   23 \tab y <- csch(100*x)                                                                              \tab 'H-Cosecant'                      \tab YES \tab NA \tab 11 \tab YES \tab YES\cr
   24 \tab y <- asinh(x)                                                                                 \tab 'I-H-Sine'                        \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   25 \tab y <- acosh(1+x)                                                                               \tab 'I-H-Cosine'                      \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   26 \tab y <- atanh(x)                                                                                 \tab 'I-H-Tangent'                     \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   27 \tab y <- acoth(1+x)                                                                               \tab 'I-H-Cotangent'                   \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   28 \tab y <- asech(x)                                                                                 \tab 'I-H-Secant'                      \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   29 \tab y <- acsch(x)                                                                                 \tab 'I-H-Cosecant'                    \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   30 \tab y <- x + 1/x                                                                                  \tab 'Hook'                            \tab YES \tab NA \tab 23 \tab YES \tab YES\cr
   31 \tab y <- (x+1)/(x-1)                                                                              \tab 'Rational Function'               \tab YES \tab NA \tab 42 \tab YES \tab YES\cr
   32 \tab y <- exp(x) / x                                                                               \tab 'Hoerl Function'                  \tab YES \tab NA \tab 13 \tab YES \tab YES\cr
   33 \tab y <- sigmoid(x-0.5)                                                                           \tab 'Sigmoid Function'                \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   34 \tab y <- logit(x)                                                                                 \tab 'Logit Function'                  \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   35 \tab y <- 1*(x>0.5)                                                                                \tab 'Step'                            \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   36 \tab y <- 0*(x<49/100) + (50*(x-0.5)+0.5) * (x >= 49/100 & x <=51/100) + (x>51/100)                \tab 'Piecewise'                       \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   37 \tab y <- 0.1*sin(10.6*(2*x-1)) + 1.1*(2*x-1)                                                      \tab 'Linear+Periodic'                 \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   38 \tab y <- sin(pi*x)/(pi*x)                                                                         \tab 'Sinc Function'                   \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   39 \tab y <- einsteinF(1,  x)                                                                         \tab 'Einstein Function1'              \tab YES \tab 5  \tab NA \tab YES \tab YES\cr
   40 \tab y <- expint_E1(x)                                                                             \tab 'Exponential Integral'            \tab YES \tab 7  \tab NA \tab YES \tab YES\cr
   41 \tab y <- Shi(x)                                                                                   \tab 'H-Sine Integral'                 \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   42 \tab y <- Chi(x)                                                                                   \tab 'H-Cosine Integral'               \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   43 \tab y <- erf(x)                                                                                   \tab 'Error Function'                  \tab YES \tab 11 \tab NA \tab YES \tab YES\cr
   44 \tab y <- erfinv(x)                                                                                \tab 'I-Error Function'                \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   45 \tab y <- gamma(x)                                                                                 \tab 'Gamma Function'                  \tab YES \tab NA \tab 32 \tab YES \tab YES\cr
   46 \tab y <- psi(0, x)                                                                                \tab 'Psi Function'                    \tab YES \tab NA \tab 33 \tab YES \tab YES\cr
   47 \tab y <- zeta(x+1)                                                                                \tab 'Riemann Zeta Function'           \tab YES \tab NA \tab 37 \tab YES \tab YES\cr
   48 \tab y <- bessel_Yn(0, x)                                                                          \tab 'Bessel Function'                 \tab YES \tab NA \tab NA \tab YES \tab YES\cr
   49 \tab y <- beta(1, x)                                                                               \tab 'Beta Function'                   \tab YES \tab NA \tab 40 \tab YES \tab YES\cr
   50 \tab y <- eta(x)                                                                                   \tab 'Dirichlet Eta Function'          \tab YES \tab 9  \tab NA \tab YES \tab YES\cr
   51 \tab y <- 4*(x-0.5)^2                                                                              \tab 'Quadratic [Symmetry]'            \tab NO  \tab NA \tab NA \tab YES \tab YES\cr
   52 \tab y <- 128*(x-1/3)^3 - 48*(x-1/3)^2-12*(x-1/3)                                                  \tab 'Cubic 2'                         \tab NO  \tab NA \tab NA \tab YES \tab YES\cr
   53 \tab y <- sin(16*pi*x)                                                                             \tab 'Sine [High Freq]'                \tab NO  \tab NA \tab NA \tab YES \tab YES\cr
   54 \tab y <- cos(14*pi*x)                                                                             \tab 'Cosine [High Freq]'              \tab NO  \tab NA \tab NA \tab YES \tab YES\cr
   55 \tab y <- 200*x*(x < 1/200) + (-198*x+199/100)*(x >= 1/200 & x < 1/100) + (-x/99+1/99) *(x>=1/100) \tab 'Lopsided L-shaped'               \tab NO  \tab NA \tab NA \tab YES \tab YES\cr
   56 \tab y <- sqrt(1-(2*x-1)^2)                                                                        \tab 'Circle'                          \tab NO  \tab NA \tab NA \tab YES \tab YES\cr
   57 \tab y <- sin(10*pi*x)+x                                                                           \tab 'Linear + Periodic [Medium Freq]' \tab NO  \tab NA \tab NA \tab YES \tab YES\cr
   58 \tab y <- 4*(2.4*x - 1.3)^3+(2.4*x - 1.3)^2-4*(2.4*x - 1.3)                                        \tab 'Cubic 3'                         \tab NO  \tab NA \tab NA \tab YES \tab YES\cr
   59 \tab y <- 41*(4*(2.4*x - 1.3)^3+(2.4*x - 1.3)^2-4*(2.4*x - 1.3))                                   \tab 'Cubic [Y-stretched]'             \tab NO  \tab NA \tab NA \tab YES \tab YES\cr
   60 \tab y <- sin(4*pi*x)                                                                              \tab 'Sine [Two Periods]'              \tab NO  \tab NA \tab NA \tab YES \tab YES\cr
   61 \tab y <- sin(8*pi*x)                                                                              \tab 'Sine [Low Freq]'                 \tab NO  \tab NA \tab NA \tab YES \tab YES\cr
   62 \tab y <- sin(9*pi*x)                                                                              \tab Sine, Non-Fourier Freq [Low]'     \tab NO  \tab NA \tab NA \tab YES \tab YES\cr
   63 \tab y <- cos(7*pi*x)                                                                              \tab Cosine, Non-Fourier Freq [Low]'   \tab NO  \tab NA \tab NA \tab YES \tab YES\cr
   64 \tab y <- sin(6*pi*x*(1+x))                                                                        \tab Sine, Varying Freq [Medium]'      \tab NO  \tab NA \tab NA \tab YES \tab YES\cr
   65 \tab y <- cos(5*pi*x*(1+x))                                                                        \tab Cosine, Varying Freq [Medium]'    \tab NO  \tab NA \tab NA \tab YES \tab YES\cr
   66 \tab y <- 0.2*sin(10.6*(2*x-1)) + 1.1*(2*x-1)                                                      \tab Linear + Periodic, High Freq 2'   \tab NO  \tab NA \tab NA \tab YES \tab YES\cr
}
}
