# Be Tangential to Manifold: Discovering Riemannian Metric for Diffusion Models

This code provides an implementation for interpolation method in diffusion models, as proposed in the paper "Be Tangential to Manifold: Discovering Riemannian Metric for Diffusion Models".

## 1. Installation

Run the following commands to install all the necessary libraries.

```bash
pip install -r requirements.txt
```

## 2. Datasets

The `data/examples` directory provides a small sample of image pairs for a quick demonstration. The pairs were created from the following larger datasets:

-   **Morphbench**:
    -   [DiffMorpher: Unleashing the Capability of Diffusion Models for Image Morphing](https://github.com/Kevin-thu/DiffMorpher)
-   **AFHQ**:
    -   [huggan/AFHQ on Hugging Face](https://huggingface.co/datasets/huggan/AFHQ)
-   **CelebA-HQ**:
    -   [korexyz/celeba-hq-256x256 on Hugging Face](https://huggingface.co/datasets/korexyz/celeba-hq-256x256)
-   **Video frame interpolation**:
    -   [Generative Inbetweening through Frame-wise Conditions-Driven Video Generation](https://fcvg-inbetween.github.io/)

You can download these datasets to create your own image pairs.

## 3. How to Run

To perform interpolation between image pairs, execute the `main.py` script.
To run the interpolation on the sample dataset defined in `data/examples.yaml`, use the following command:

```bash
python main.py examples
```

## 4. How to Add a New Dataset

1.  Create a new directory inside `data/` and place your image pairs there (e.g., `data/my_dataset/`).
2.  Create a new YAML file in the `data/` directory (e.g., `data/my_dataset.yaml`).
3.  Following the format of `data/examples.yaml`, define entries for each pair, specifying the image paths and a corresponding prompt.
4.  Run `main.py` with the name of the dataset.

```bash
python main.py my_dataset
```

### Command-line Arguments

-   **`dataset`** (Required): The name of the YAML file that defines the data pairs (e.g., examples).
-   **`--c`**: Path to the configuration file (default: `configs/config.yaml`).
-   **`--iters`**: Number of optimization iterations.
-   **`--lr`**: Learning rate for the optimization.
-   **`--out_dir`**: Directory to save the output results.

## 5. Output

The interpolation results will be saved in the output directory specified in `configs/config.yaml`. The default directory is `results/`.
