import yaml

from model.pipeline import load_pipe
from utils import *


def main():
    args = parse_main_args()
    config = yaml.safe_load(open(args.c))
    config = override_config_from_args(config, args)

    pipe = load_pipe("cuda")

    data_path_dict = create_data_path_dict_from(f"{args.dataset}")
    target_items = get_split_items(
        list(data_path_dict.items()), args.num_splits, args.split_index
    )

    for id, paths in target_items:
        process_pair(id, paths, config, pipe)

    print("--- All interpolation complete. ---")


if __name__ == "__main__":
    main()
