# Code for paper Representation Learning for Low-rank General-sum Markov Games

## Prerequisites

Creating a virtual environment is recommended (or using conda alternatively):
```bash
pip install virtualenv
virtualenv /path/to/venv --python=python3

#To activate a virtualenv: 

. /path/to/venv/bin/activate
```

To install the dependencies (the results from the paper are obtain from gym==0.14.0):
``` bash
pip install -r requirements.txt
```

To install pytorch, please follow [PyTorch](http://pytorch.org/). Note that the current implementation does not require pytorch gpu.

We use [wandb](https://wandb.ai/home) to collect results, please setup wandb before running the code or add `os.environ['WANDB_MODE'] = 'offline'` in `*.py` files.

## Run our code

To test our method in zero-sum setting, please run:
```bash
bash run.sh [env-seed]
```

To test our method in general-sum setting, please run:
```bash
bash run_gensum.sh [env-seed]
```


To see all the hyperparameters, please refer to `utils.py`.

