import json
import argparse
from trainer import train
import random

ep_arr = [170]
milestone_arr = [3]

lr_arr = [0.1]
lr_decay_arr = [0.1]
batch_arr = [128]
w_decay_arr = [0.0002]
scheduler_arr = ['steplr']

lambda_aux_arr = [1]
examplar_batch_size_arr = [64]

seed_arr = [0,1,2]
total_rand_num = 1

def main():
    args = setup_parser().parse_args()
    param = load_json(args.config)
    args = vars(args)  # Converting argparse Namespace to a dict.
    args.update(param)  # Add parameters from json
    
    for rand_num in range(total_rand_num):
        
        seed = random.choice(seed_arr)
        ep = random.choice(ep_arr)
        milestone_num = random.choice(milestone_arr)
        lr = random.choice(lr_arr)
        lr_decay = random.choice(lr_decay_arr)
        batch = random.choice(batch_arr)
        w_decay = random.choice(w_decay_arr)
        scheduler = random.choice(scheduler_arr)
        
        lambda_aux = random.choice(lambda_aux_arr)
        examplar_batch_size = random.choice(examplar_batch_size_arr)
        
        
        milestones = [80,120,150]
            
        prefix = "0_origin_ep_{}_milestone_{}_lr_{}_lr_decay_{}_batch_{}_w_decay_{}_scheduler_{}_lambda_aux_{}_examplar_bs_{}".format(
                        ep,
                        milestone_num,
                        lr,
                        lr_decay,
                        batch,
                        w_decay,
                        scheduler,
                        lambda_aux,
                        examplar_batch_size,
                    )
            
        parameters = {
            "seed":seed_arr, 
            "prefix":prefix, 
            "epochs":ep,
            "lrate":lr,
            "milestones":milestones,
            "lrate_decay":lr_decay,
            "batch_size":batch,
            "weight_decay":w_decay,
            "scheduler":scheduler,
            "lambda_aux":lambda_aux,
            "examplar_batch_size":examplar_batch_size,
        }

        args.update(parameters)  # Add parameters from json

        print (args)

        train(args)
                        
    


def load_json(settings_path):
    with open(settings_path) as data_file:
        param = json.load(data_file)

    return param


def setup_parser():
    parser = argparse.ArgumentParser(description='Reproduce of multiple continual learning algorthms.')
    parser.add_argument('--config', type=str, default='./exps/finetune.json',
                        help='Json file of settings.')

    return parser


if __name__ == '__main__':
    main()
