import json
import argparse
from trainer import train
import random

ep_arr = [70]
# milestone_arr = [2, 3, 4]

lr_arr = [0.1]
lr_decay_arr = [0.1]
batch_arr = [128]
w_decay_arr = [2e-4]
scheduler_arr = ['steplr']

#SEED 부분 정리필요
seed_arr = [0,1,2,3,4]
total_rand_num = 1

def main():
    args = setup_parser().parse_args()
    param = load_json(args.config)
    args = vars(args)  # Converting argparse Namespace to a dict.
    args.update(param)  # Add parameters from json
    
    for rand_num in range(total_rand_num):
        
        ep = random.choice(ep_arr)
#         milestone_num = random.choice(milestone_arr)
        lr = random.choice(lr_arr)
        lr_decay = random.choice(lr_decay_arr)
        batch = random.choice(batch_arr)
        w_decay = random.choice(w_decay_arr)
        scheduler = random.choice(scheduler_arr)
        seed = random.choice(seed_arr)
        
        milestones = [60, 120, 170]
        
        prefix = "0_joint_origin_ep_{}_lr_{}_lr_decay_{}_batch_{}_w_decay_{}_scheduler_{}".format(
                        ep,
                        lr,
                        lr_decay,
                        batch,
                        w_decay,
                        scheduler
                    )

        parameters = {
            "seed":seed_arr, 
            "prefix":prefix, 
            "epochs":ep,
            "lrate":lr,
            "milestones":milestones,
            "lrate_decay":lr_decay,
            "batch_size":batch,
            "weight_decay":w_decay,
            "scheduler":scheduler,
        }
        args.update(parameters)  # Add parameters from json

        print (args)

        train(args)
                        
    


def load_json(settings_path):
    with open(settings_path) as data_file:
        param = json.load(data_file)

    return param


def setup_parser():
    parser = argparse.ArgumentParser(description='Reproduce of multiple continual learning algorthms.')
    parser.add_argument('--config', type=str, default='./exps/finetune.json',
                        help='Json file of settings.')

    return parser


if __name__ == '__main__':
    main()
