import argparse

def args_parser():
    parser = argparse.ArgumentParser(description='FL incentive bsline')
    parser.add_argument('--name', '-n',
                        default="default",
                        type=str,
                        help='experiment name, used for saving results')
    parser.add_argument('--samedata',
                        action='store_true',
                        help='whether we use the same data or not')
    parser.add_argument('--lr',
                        default=0.05,
                        type=float,
                        help='client learning rate')
    parser.add_argument('--glr',
                        default=0.05,
                        type=float,
                        help='local learning rate')
    parser.add_argument('--bs',
                        default=64,
                        type=int,
                        help='batch size on each worker/client')
    parser.add_argument('--inc_bs',
                        default=64,
                        type=int,
                        help='inc. batch size on each worker/client')
    parser.add_argument('--cp',
                        default=30,
                        type=int,
                        help='number of local epochs')
    parser.add_argument('--q',
                        default=1,
                        type=float,
                        help='qffl params')
    parser.add_argument('--mwfed_c',
                        default=1.5,
                        type=float,
                        help='MW-Fed C')
    parser.add_argument('--bo_cp',
                        default=500,
                        type=int,
                        help='number of local epochs')
    parser.add_argument('--better_cp',
                        default=500,
                        type=int,
                        help='number of local epochs')
    parser.add_argument('--cp_loctune',
                        default=1,
                        type=int,
                        help='number of local epochs for local tuning')
    parser.add_argument('--local_tune',
                        default=0,
                        type=bool,
                        help='do local tuning or not')
    parser.add_argument('--hetero',
                        default='00',
                        type=str,
                        help='type of dataset')
    parser.add_argument('--optype',
                        default=1,
                        type=int,
                        help='type of optimization method')
    parser.add_argument('--leave',
                        default=0,
                        type=int,
                        help='type of optimization method')
    parser.add_argument('--total_rnd',
                        default=500,
                        type=int,
                        help='total communication rounds')
    parser.add_argument('--numusers',
                        default=30,
                        type=int,
                        help='# of entire clients')
    parser.add_argument('--sample_ratio',
                        default=30,
                        type=int,
                        help='# of selected clients')
    parser.add_argument('--train_ratio',
                        default=0.6,
                        type=float,
                        help='proportion of training data')
    parser.add_argument('--val_ratio',
                        default=0.6,
                        type=float,
                        help='proportion of validation data')
    parser.add_argument('--test_ratio',
                        default=0.6,
                        type=float,
                        help='proportion of test data')
    parser.add_argument('--seed',
                        default=2,
                        type=int,
                        help='seed for rng')


    args = parser.parse_args()

    return args