import torch.nn as nn
import torch.nn.functional as F
import torch.nn.functional as func

class MLP(nn.Module):
    def __init__(self, input_size, output_size):
        super(MLP, self).__init__()
        self.linear1 = nn.Linear(input_size, 128)
        self.linear2 = nn.Linear(128, 10)

    def forward(self, x):
        x = x.view(-1, 28 * 28)
        x = F.relu(self.linear1(x))
        x = self.linear2(x)

        return (x)

class MLP_sent140(nn.Module):
    def __init__(self, input_size, dim_hidden1, dim_hidden2, dim_hidden3, dim_out):
        super(MLP_sent140, self).__init__()
        self.layer_input = nn.Linear(input_size, dim_hidden1)
        self.relu = nn.ReLU()
        self.dropout = nn.Dropout()
        self.layer_hidden1 = nn.Linear(dim_hidden1, dim_hidden2)
        self.layer_hidden2 = nn.Linear(dim_hidden2, dim_hidden3)
        self.layer_hidden3 = nn.Linear(dim_hidden3, dim_out)

    def forward(self, x):
        x = self.layer_input(x)
        x = self.relu(x)
        x = self.layer_hidden1(x)
        x = self.relu(x)
        x = self.layer_hidden2(x)
        x = self.relu(x)
        x = self.layer_hidden3(x)

        return x

