from transformers import DebertaConfig as _DebertaConfig
from transformers.models.bert import BertConfig


class RobertaConfig(BertConfig):
    model_type = "roberta"

    def __init__(
        self,
        prompt_length=None,
        prompt_rank=None,
        training_type=None,
        pad_token_id=1,
        bos_token_id=0,
        eos_token_id=2,
        **kwargs
    ):
        super().__init__(
            pad_token_id=pad_token_id,
            bos_token_id=bos_token_id,
            eos_token_id=eos_token_id,
            **kwargs
        )

        self.training_type = training_type
        self.prompt_length = prompt_length
        self.prompt_rank = prompt_rank


class DebertaConfig(_DebertaConfig):
    def __init__(
        self, prompt_length=None, prompt_rank=None, training_type=None, **kwargs
    ):
        super().__init__(**kwargs)

        self.training_type = training_type
        self.prompt_length = prompt_length
        self.prompt_rank = prompt_rank
