from transformers.models.deberta.modeling_deberta import (
    DebertaForQuestionAnswering,
    DebertaForSequenceClassification,
)
from transformers.models.roberta.modeling_roberta import (
    RobertaForMultipleChoice,
    RobertaForSequenceClassification,
)

from zarya.model.multichoice import DebertaForMultipleChoice
from zarya.model.prefix import (
    DebertaPrefixForMultipleChoice,
    DebertaPrefixForQuestionAnswering,
    DebertaPrefixForSequenceClassification,
    RobertaPrefixForMultipleChoice,
    RobertaPrefixForSequenceClassification,
)
from zarya.model.prompt import (
    DebertaPromptForMultipleChoice,
    DebertaPromptForQuestionAnswering,
    DebertaPromptForSequenceClassification,
    RobertaPromptForMultipleChoice,
    RobertaPromptForSequenceClassification,
)
from zarya.model.zero import (
    DebertaZeroForMultipleChoice,
    DebertaZeroForQuestionAnswering,
    DebertaZeroForSequenceClassification,
    RobertaZeroForMultipleChoice,
    RobertaZeroForSequenceClassification,
)

MODEL_CLS = {
    "classification": {
        "full": {
            "roberta": RobertaForSequenceClassification,
            "deberta": DebertaForSequenceClassification,
        },
        "lora": {
            "roberta": RobertaForSequenceClassification,
            "deberta": DebertaForSequenceClassification,
        },
        "adapter": {
            "roberta": RobertaForSequenceClassification,
            "deberta": DebertaForSequenceClassification,
        },
        "bitfit": {
            "roberta": RobertaForSequenceClassification,
            "deberta": DebertaForSequenceClassification,
        },
        "prompt": {
            "roberta": RobertaPromptForSequenceClassification,
            "deberta": DebertaPromptForSequenceClassification,
        },
        "prefix": {
            "roberta": RobertaPrefixForSequenceClassification,
            "deberta": DebertaPrefixForSequenceClassification,
        },
        "zero": {
            "roberta": RobertaZeroForSequenceClassification,
            "deberta": DebertaZeroForSequenceClassification,
        },
    },
    "regression": {
        "full": {
            "roberta": RobertaForSequenceClassification,
            "deberta": DebertaForSequenceClassification,
        },
        "lora": {
            "roberta": RobertaForSequenceClassification,
            "deberta": DebertaForSequenceClassification,
        },
        "adapter": {
            "roberta": RobertaForSequenceClassification,
            "deberta": DebertaForSequenceClassification,
        },
        "bitfit": {
            "roberta": RobertaForSequenceClassification,
            "deberta": DebertaForSequenceClassification,
        },
        "prompt": {
            "roberta": RobertaPromptForSequenceClassification,
            "deberta": DebertaPromptForSequenceClassification,
        },
        "prefix": {
            "roberta": RobertaPrefixForSequenceClassification,
            "deberta": DebertaPrefixForSequenceClassification,
        },
        "zero": {
            "roberta": RobertaZeroForSequenceClassification,
            "deberta": DebertaZeroForSequenceClassification,
        },
    },
    "multi": {
        "full": {
            "roberta": RobertaForMultipleChoice,
            "deberta": DebertaForMultipleChoice,
        },
        "lora": {
            "roberta": RobertaForMultipleChoice,
            "deberta": DebertaForMultipleChoice,
        },
        "adapter": {
            "roberta": RobertaForMultipleChoice,
            "deberta": DebertaForMultipleChoice,
        },
        "bitfit": {
            "roberta": RobertaForMultipleChoice,
            "deberta": DebertaForMultipleChoice,
        },
        "prompt": {
            "roberta": RobertaPromptForMultipleChoice,
            "deberta": DebertaPromptForMultipleChoice,
        },
        "prefix": {
            "roberta": RobertaPrefixForMultipleChoice,
            "deberta": DebertaPrefixForMultipleChoice,
        },
        "zero": {
            "roberta": RobertaZeroForMultipleChoice,
            "deberta": DebertaZeroForMultipleChoice,
        },
    },
    "qa": {
        "full": {
            "deberta": DebertaForQuestionAnswering,
        },
        "prompt": {
            "deberta": DebertaPromptForQuestionAnswering,
        },
        "prefix": {
            "deberta": DebertaPrefixForQuestionAnswering,
        },
        "zero": {
            "deberta": DebertaZeroForQuestionAnswering,
        },
    },
}
