close all; clear all; clc;
m=200; r=10; n = 200; T = 100;

SS = [0,1e-9,1e-8,1e-7,1e-6,1e-5,1e-4, 1e-3, 1e-2, 1e-1, 1];    %variance sigma^2

% Variables we want to keep track of
errWeX = ones(T,length(SS));   % Approximation error in X
errWeY = ones(T,length(SS));   % Track PCA error for sanity check

errPCAX = ones(T,length(SS));   % Track PCA error for baseline
errPCAY = ones(T,length(SS));   % Track PCA error for sanity check

%Run experiments
for ss=1:length(SS)
    s = SS(ss);
    th = sqrt(s/m);
    for t=1:T
        [r,ss,t]

        % Generate data
        [X,W,H,Omega] = genOrthData(m,r,n);
        Z = sqrt(s)*randn(m,n);
        Y = max(0,X + Z);
        
        % Compute projection matrix
        [Uh,~,~] = svd(Y);
        Uh = Uh(:,1:r);
        Vh = Uh'*Y;
        Ph = Uh/(Uh'*Uh)*Uh';

        % Do spectral clustering
        Omegah = SpectralClustering(abs(Ph),r);
        Omegah = bestMap(Omega,Omegah);

        % Get one vector per group
        We = zeros(m,r);
        for k=1:r
            [Wk,~,~] = svd(Y(Omegah==k,:));
            We(Omegah==k,k) = Wk(:,1) * sign( mean( Wk(:,1) ) );
        end

        % Get second factor and approximation
        He = We' * Y;
        Xe = We * He;

        % Compute errors
        errWeX(t,ss) = norm(X-Xe,'fro')/norm(X,'fro');
        errWeY(t,ss) = norm(Y-Xe,'fro')/norm(Y,'fro');


        % Keep track of PCA error for baseline
        Xpca = Uh * Vh;
        errPCAX(t,ss) = norm(X-Xpca,'fro')/norm(X,'fro');
        errPCAY(t,ss) = norm(Y-Xpca,'fro')/norm(Y,'fro');

    end
end

subplot(1,2,1);
semilogy(mean(errWeX),'r');
hold on;
semilogy(mean(errPCAX),'b');

subplot(1,2,2);
semilogy(mean(errWeY),'r');
hold on;
semilogy(mean(errPCAY),'b');


